/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.random.generators;

import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.Indexer;
import edu.uci.ics.jung.graph.impl.UndirectedSparseGraph;
import edu.uci.ics.jung.random.generators.GraphGenerator;
import edu.uci.ics.jung.utils.GraphUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class EppsteinPowerLawGenerator
implements GraphGenerator {
    private int mNumVertices;
    private int mNumEdges;
    private int mNumIterations;
    private double mMaxDegree;
    private Random mRandom;

    public EppsteinPowerLawGenerator(int numVertices, int numEdges, int r) {
        this.mNumVertices = numVertices;
        this.mNumEdges = numEdges;
        this.mNumIterations = r;
        this.mRandom = new Random();
    }

    protected Graph initializeGraph() {
        UndirectedSparseGraph graph = null;
        graph = new UndirectedSparseGraph();
        GraphUtils.addVertices((Graph)graph, this.mNumVertices);
        Indexer id = Indexer.getIndexer(graph);
        while (graph.numEdges() < this.mNumEdges) {
            Vertex u = (Vertex)id.getVertex((int)(this.mRandom.nextDouble() * (double)this.mNumVertices));
            Vertex v = (Vertex)id.getVertex((int)(this.mRandom.nextDouble() * (double)this.mNumVertices));
            if (v.isSuccessorOf(u)) continue;
            GraphUtils.addEdge(graph, u, v);
        }
        double maxDegree = 0.0;
        Iterator vIt = graph.getVertices().iterator();
        while (vIt.hasNext()) {
            Vertex v = (Vertex)vIt.next();
            maxDegree = Math.max((double)v.degree(), maxDegree);
        }
        this.mMaxDegree = maxDegree;
        return graph;
    }

    public ArchetypeGraph generateGraph() {
        Graph graph = this.initializeGraph();
        Indexer id = Indexer.getIndexer(graph);
        for (int rIdx = 0; rIdx < this.mNumIterations; ++rIdx) {
            Vertex v = null;
            int degree = 0;
            while ((degree = (v = (Vertex)id.getVertex((int)(this.mRandom.nextDouble() * (double)this.mNumVertices))).degree()) == 0) {
            }
            ArrayList edges = new ArrayList(v.getIncidentEdges());
            Edge randomExistingEdge = (Edge)edges.get((int)(this.mRandom.nextDouble() * (double)degree));
            Vertex x = (Vertex)id.getVertex((int)(this.mRandom.nextDouble() * (double)this.mNumVertices));
            Vertex y = null;
            do {
                y = (Vertex)id.getVertex((int)(this.mRandom.nextDouble() * (double)this.mNumVertices));
            } while (this.mRandom.nextDouble() > (double)(y.degree() + 1) / this.mMaxDegree);
            if (y.isSuccessorOf(x) || x == y) continue;
            graph.removeEdge(randomExistingEdge);
            GraphUtils.addEdge(graph, x, y);
        }
        return graph;
    }

    public void setSeed(long seed) {
        this.mRandom.setSeed(seed);
    }
}

