/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform;

import edu.uci.ics.jung.utils.ChangeEventSupport;
import edu.uci.ics.jung.utils.DefaultChangeEventSupport;
import edu.uci.ics.jung.visualization.transform.AffineTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.shape.ShapeTransformer;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.event.ChangeListener;

public class MutableAffineTransformer
extends AffineTransformer
implements MutableTransformer,
ShapeTransformer,
ChangeEventSupport {
    protected ChangeEventSupport changeSupport = new DefaultChangeEventSupport(this);

    public MutableAffineTransformer() {
    }

    public MutableAffineTransformer(AffineTransform transform) {
        super(transform);
    }

    public String toString() {
        return "MutableAffineTransformer using " + this.transform;
    }

    public void scale(double scalex, double scaley, Point2D from) {
        AffineTransform xf = AffineTransform.getTranslateInstance(from.getX(), from.getY());
        xf.scale(scalex, scaley);
        xf.translate(-from.getX(), -from.getY());
        this.inverse = null;
        this.transform.preConcatenate(xf);
        this.fireStateChanged();
    }

    public void setScale(double scalex, double scaley, Point2D from) {
        this.transform.setToIdentity();
        this.scale(scalex, scaley, from);
    }

    public void shear(double shx, double shy, Point2D from) {
        this.inverse = null;
        AffineTransform at = AffineTransform.getTranslateInstance(from.getX(), from.getY());
        at.shear(shx, shy);
        at.translate(-from.getX(), -from.getY());
        this.transform.preConcatenate(at);
        this.fireStateChanged();
    }

    public void setTranslate(double tx, double ty) {
        float scalex = (float)this.transform.getScaleX();
        float scaley = (float)this.transform.getScaleY();
        float shearx = (float)this.transform.getShearX();
        float sheary = (float)this.transform.getShearY();
        this.inverse = null;
        this.transform.setTransform(scalex, sheary, shearx, scaley, tx, ty);
        this.fireStateChanged();
    }

    public void translate(double offsetx, double offsety) {
        this.inverse = null;
        this.transform.translate(offsetx, offsety);
        this.fireStateChanged();
    }

    public void rotate(double theta, Point2D from) {
        AffineTransform rotate = AffineTransform.getRotateInstance(theta, from.getX(), from.getY());
        this.inverse = null;
        this.transform.preConcatenate(rotate);
        this.fireStateChanged();
    }

    public void rotate(double radians, double x, double y) {
        this.inverse = null;
        this.transform.rotate(radians, x, y);
        this.fireStateChanged();
    }

    public void concatenate(AffineTransform xform) {
        this.inverse = null;
        this.transform.concatenate(xform);
        this.fireStateChanged();
    }

    public void preConcatenate(AffineTransform xform) {
        this.inverse = null;
        this.transform.preConcatenate(xform);
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeSupport.getChangeListeners();
    }

    public void fireStateChanged() {
        this.changeSupport.fireStateChanged();
    }

    public void setToIdentity() {
        this.inverse = null;
        this.transform.setToIdentity();
        this.fireStateChanged();
    }
}

