/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.renderers.Renderer;

public class IDEAJRenderer
implements Renderer {
    protected String EOL = System.getProperty("line.separator", "\n");
    private String[] args;

    public IDEAJRenderer(String[] args) {
        this.args = args;
    }

    public String render(Report report) {
        if (this.args[4].equals(".method")) {
            String sourcePath = this.args[3];
            return this.render(report, sourcePath);
        }
        String classAndMethodName = this.args[4];
        String singleFileName = this.args[5];
        return this.render(report, classAndMethodName, singleFileName);
    }

    private String render(Report report, String sourcePathString) {
        SourcePath sourcePath = new SourcePath(sourcePathString);
        StringBuffer buf = new StringBuffer();
        Iterator i = report.iterator();
        while (i.hasNext()) {
            RuleViolation rv = (RuleViolation)i.next();
            buf.append(rv.getDescription() + this.EOL);
            buf.append(" at " + this.getFullyQualifiedClassName(rv.getFilename(), sourcePath) + ".method(" + this.getSimpleFileName(rv.getFilename()) + ":" + rv.getLine() + ")" + this.EOL);
        }
        return buf.toString();
    }

    private String render(Report report, String classAndMethod, String file) {
        StringBuffer buf = new StringBuffer();
        Iterator i = report.iterator();
        while (i.hasNext()) {
            RuleViolation rv = (RuleViolation)i.next();
            buf.append(rv.getDescription() + this.EOL);
            buf.append(" at " + classAndMethod + "(" + file + ":" + rv.getLine() + ")" + this.EOL);
        }
        return buf.toString();
    }

    private String getFullyQualifiedClassName(String in, SourcePath sourcePath) {
        String classNameWithSlashes = sourcePath.clipPath(in);
        String className = classNameWithSlashes.replace(System.getProperty("file.separator").charAt(0), '.');
        return className.substring(0, className.indexOf(".java"));
    }

    private String getSimpleFileName(String in) {
        return in.substring(in.lastIndexOf(System.getProperty("file.separator")) + 1);
    }

    private static class SourcePath {
        private Set paths = new HashSet();

        public SourcePath(String sourcePathString) {
            StringTokenizer st = new StringTokenizer(sourcePathString, ";");
            while (st.hasMoreTokens()) {
                this.paths.add(st.nextToken());
            }
        }

        public String clipPath(String fullFilename) {
            Iterator i = this.paths.iterator();
            while (i.hasNext()) {
                String path = (String)i.next();
                if (!fullFilename.startsWith(path)) continue;
                return fullFilename.substring(path.length() + 1);
            }
            throw new RuntimeException("Couldn't find src path for " + fullFilename);
        }
    }
}

