/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.sourceforge.pmd.swingui.DirectoryTableModel;
import net.sourceforge.pmd.swingui.DirectoryTree;
import net.sourceforge.pmd.swingui.event.DirectoryTableEvent;
import net.sourceforge.pmd.swingui.event.DirectoryTableEventListener;
import net.sourceforge.pmd.swingui.event.ListenerList;

class DirectoryTable
extends JTable {
    private boolean m_sortAscending = true;

    protected DirectoryTable(DirectoryTree directoryTree, String fileExtension) {
        super(new DirectoryTableModel(directoryTree, fileExtension));
        this.setShowGrid(false);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(true);
        this.getSelectionModel().setSelectionMode(0);
        this.setBackground(UIManager.getColor("pmdTableBackground"));
        this.setRowHeight(20);
        this.setSelectionBackground(Color.blue);
        this.setSelectionForeground(Color.white);
        this.getSelectionModel().addListSelectionListener(new ListSelectionHandler());
        TableColumnModel columnModel = this.getColumnModel();
        JTableHeader tableHeader = this.getTableHeader();
        columnModel.setColumnMargin(2);
        tableHeader.addMouseListener(new TableHeaderMouseListener());
        TableColumn column = columnModel.getColumn(0);
        ColumnHeaderRenderer headerRenderer = new ColumnHeaderRenderer();
        DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer();
        cellRenderer.setIcon(UIManager.getIcon("document"));
        headerRenderer.setHorizontalAlignment(2);
        column.setHeaderRenderer(headerRenderer);
        cellRenderer.setHorizontalAlignment(2);
        column.setCellRenderer(cellRenderer);
        column = columnModel.getColumn(1);
        headerRenderer = new ColumnHeaderRenderer();
        cellRenderer = new DefaultTableCellRenderer();
        headerRenderer.setHorizontalAlignment(4);
        column.setHeaderRenderer(headerRenderer);
        cellRenderer.setHorizontalAlignment(4);
        column.setCellRenderer(cellRenderer);
        column = columnModel.getColumn(2);
        headerRenderer = new ColumnHeaderRenderer();
        cellRenderer = new DefaultTableCellRenderer();
        headerRenderer.setHorizontalAlignment(2);
        column.setHeaderRenderer(headerRenderer);
        cellRenderer.setHorizontalAlignment(2);
        column.setCellRenderer(cellRenderer);
        ListenerList.addListener(new DirectoryTableEventHandler());
    }

    protected File getSelectedFile() {
        ListSelectionModel selectionModel = this.getSelectionModel();
        int row = selectionModel.getAnchorSelectionIndex();
        DirectoryTableModel tableModel = (DirectoryTableModel)this.getModel();
        return tableModel.getFile(row);
    }

    private class DirectoryTableEventHandler
    implements DirectoryTableEventListener {
        private DirectoryTableEventHandler() {
        }

        public void requestSelectedFile(DirectoryTableEvent event) {
            File file = DirectoryTable.this.getSelectedFile();
            if (file != null) {
                DirectoryTableEvent.notifySelectedFile(this, file);
            }
        }

        public void fileSelectionChanged(DirectoryTableEvent event) {
        }

        public void fileSelected(DirectoryTableEvent event) {
        }
    }

    private class ListSelectionHandler
    implements ListSelectionListener {
        private ListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent event) {
            File file;
            if (!event.getValueIsAdjusting() && (file = DirectoryTable.this.getSelectedFile()) != null) {
                DirectoryTableEvent.notifyFileSelectionChanged(this, file);
            }
        }
    }

    private class TableSortComparator
    implements Comparator {
        private int m_sortColumn;
        private boolean m_sortAscending;

        private TableSortComparator(int sortColumn, boolean sortAscending) {
            this.m_sortColumn = sortColumn;
            this.m_sortAscending = sortAscending;
        }

        public int compare(Object rowA, Object rowB) {
            String keyA = (String)((Vector)rowA).get(this.m_sortColumn);
            String keyB = (String)((Vector)rowB).get(this.m_sortColumn);
            if (this.m_sortAscending) {
                return keyA.compareTo(keyB);
            }
            return keyB.compareTo(keyA);
        }

        public boolean equals(Object object) {
            return object == this;
        }
    }

    private class TableHeaderMouseListener
    extends MouseAdapter {
        private TableHeaderMouseListener() {
        }

        public void mouseReleased(MouseEvent event) {
            DirectoryTable.this.m_sortAscending = !DirectoryTable.this.m_sortAscending;
            Point mouseLocation = event.getPoint();
            JTableHeader tableHeader = DirectoryTable.this.getTableHeader();
            int sortColumn = tableHeader.columnAtPoint(mouseLocation);
            if (sortColumn >= 0) {
                Rectangle columnHeaderArea = tableHeader.getHeaderRect(sortColumn);
                columnHeaderArea.x -= 10;
                columnHeaderArea.width -= 20;
                if (columnHeaderArea.contains(mouseLocation)) {
                    this.sort(sortColumn, DirectoryTable.this.m_sortAscending);
                }
            }
        }

        protected void sort(int sortColumn, boolean sortAscending) {
            TableSortComparator comparator = new TableSortComparator(sortColumn, sortAscending);
            DirectoryTableModel tableModel = (DirectoryTableModel)DirectoryTable.this.getModel();
            Vector<Vector> tableData = tableModel.getDataVector();
            int rowCount = tableData.size();
            Vector[] rows = new Vector[rowCount];
            rows = tableData.toArray(rows);
            Arrays.sort(rows, comparator);
            int n = 0;
            while (n < rowCount) {
                tableData.set(n, rows[n]);
                ++n;
            }
            tableModel.fireTableDataChanged();
        }
    }

    private class ColumnHeaderRenderer
    extends DefaultTableCellRenderer {
        private Font m_boldFont;
        private Border m_border;
        private Color m_background;
        private Color m_foreground;

        protected ColumnHeaderRenderer() {
            Font oldFont = this.getFont();
            this.m_boldFont = new Font(oldFont.getName(), 1, oldFont.getSize());
            BevelBorder bevelBorder = new BevelBorder(0);
            EtchedBorder etchedBorder = new EtchedBorder(0);
            this.m_border = new CompoundBorder(etchedBorder, bevelBorder);
            this.m_background = UIManager.getColor("pmdTableHeaderBackground");
            this.m_foreground = UIManager.getColor("pmdTableHeaderForeground");
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setFont(this.m_boldFont);
            this.setBorder(this.m_border);
            this.setBackground(this.m_background);
            this.setForeground(this.m_foreground);
            this.setHorizontalAlignment(0);
            return this;
        }
    }
}

