/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.rules.design;

import junit.framework.Assert;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.ReportListener;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.rules.design.UseSingletonRule;
import net.sourceforge.pmd.stat.Metric;
import test.net.sourceforge.pmd.rules.RuleTst;

public class UseSingletonRuleTest
extends RuleTst
implements ReportListener {
    private int callbacks;
    private static final String TEST1 = "public class Foo {" + CPD.EOL + " // Should trigger UseSingleton rule?" + CPD.EOL + " public Foo() { }" + CPD.EOL + " public static void doSomething() {}" + CPD.EOL + " public static void main(String args[]) {" + CPD.EOL + "  doSomething();" + CPD.EOL + " }" + CPD.EOL + "}";
    private static final String TEST2 = "public class UseSingleton2" + CPD.EOL + "{" + CPD.EOL + "    // Should not trigger UseSingleton rule." + CPD.EOL + "    public UseSingleton2() { }" + CPD.EOL + "    public void doSomething() { }" + CPD.EOL + "    public static void main(String args[]) { }" + CPD.EOL + "}";
    private static final String TEST3 = "public class UseSingleton3" + CPD.EOL + "{" + CPD.EOL + "    // Should trigger it." + CPD.EOL + "    public static void doSomething1() { }" + CPD.EOL + "    public static void doSomething2() { }" + CPD.EOL + "    public static void doSomething3() { }" + CPD.EOL + "}";
    private static final String TEST4 = "public class UseSingleton4" + CPD.EOL + "{" + CPD.EOL + "    public UseSingleton4() { }" + CPD.EOL + "}";
    private static final String TEST5 = "public class UseSingleton5 {" + CPD.EOL + " private UseSingleton5() {}" + CPD.EOL + " public static UseSingleton5 get() {" + CPD.EOL + "  return null;" + CPD.EOL + " }     " + CPD.EOL + "}";
    private static final String TEST6 = "public abstract class Foo {" + CPD.EOL + "    public static void doSomething1() { }" + CPD.EOL + "    public static void doSomething2() { }" + CPD.EOL + "    public static void doSomething3() { }" + CPD.EOL + "}";

    public void testAllStaticsPublicConstructor() throws Throwable {
        this.runTestFromString(TEST1, 1, new UseSingletonRule());
    }

    public void testOKDueToNonStaticMethod() throws Throwable {
        this.runTestFromString(TEST2, 0, new UseSingletonRule());
    }

    public void testNoConstructorCoupleOfStatics() throws Throwable {
        this.runTestFromString(TEST3, 1, new UseSingletonRule());
    }

    public void testNoConstructorOneStatic() throws Throwable {
        this.runTestFromString(TEST4, 0, new UseSingletonRule());
    }

    public void testClassicSingleton() throws Throwable {
        this.runTestFromString(TEST5, 0, new UseSingletonRule());
    }

    public void testAbstractSingleton() throws Throwable {
        this.runTestFromString(TEST6, 0, new UseSingletonRule());
    }

    public void testResetState() throws Throwable {
        this.callbacks = 0;
        UseSingletonRule rule = new UseSingletonRule();
        Report report = new Report();
        report.addListener(this);
        this.runTestFromString(TEST3, rule, report);
        this.runTestFromString(TEST4, rule, report);
        Assert.assertEquals((int)1, (int)this.callbacks);
    }

    public void ruleViolationAdded(RuleViolation ruleViolation) {
        ++this.callbacks;
    }

    public void metricAdded(Metric metric) {
    }
}

