/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapConfig;
import de.kapsi.net.daap.DaapServer;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.bio.DaapServerBIO;
import de.kapsi.net.daap.nio.DaapServerNIO;

public class DaapServerFactory {
    private DaapServerFactory() {
    }

    public static DaapServer createServer(Library library, boolean nio) {
        if (nio) {
            return DaapServerFactory.createNIOServer(library);
        }
        return DaapServerFactory.createBIOServer(library);
    }

    public static DaapServer createServer(Library library, DaapConfig config, boolean nio) {
        if (nio) {
            return DaapServerFactory.createNIOServer(library, config);
        }
        return DaapServerFactory.createBIOServer(library, config);
    }

    public static DaapServer createBIOServer(Library library) {
        return new DaapServerBIO(library);
    }

    public static DaapServer createBIOServer(Library library, DaapConfig config) {
        return new DaapServerBIO(library, config);
    }

    public static DaapServer createNIOServer(Library library) {
        return new DaapServerNIO(library);
    }

    public static DaapServer createNIOServer(Library library, DaapConfig config) {
        return new DaapServerNIO(library, config);
    }
}

