/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.predicates;

import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.predicates.GraphPredicate;
import java.util.Iterator;
import java.util.Set;

public class CliqueGraphPredicate
extends GraphPredicate {
    private static final String message = "CliqueGraphPredicate";
    private static CliqueGraphPredicate instance;

    protected CliqueGraphPredicate() {
    }

    public static CliqueGraphPredicate getInstance() {
        if (instance == null) {
            instance = new CliqueGraphPredicate();
        }
        return instance;
    }

    public boolean evaluateGraph(ArchetypeGraph g) {
        Iterator iter = g.getVertices().iterator();
        while (iter.hasNext()) {
            Vertex v = (Vertex)iter.next();
            int wanted = g.numVertices() - 1;
            Set s = v.getNeighbors();
            if (s.contains(v)) {
                ++wanted;
            }
            if (s.size() == wanted) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return message;
    }
}

