/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.predicates;

import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.predicates.GraphPredicate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class ConnectedGraphPredicate
extends GraphPredicate {
    private static ConnectedGraphPredicate instance;
    private static String message;

    public static ConnectedGraphPredicate getInstance() {
        if (instance == null) {
            instance = new ConnectedGraphPredicate();
        }
        return instance;
    }

    protected ConnectedGraphPredicate() {
    }

    public String toString() {
        return message;
    }

    public boolean evaluateGraph(ArchetypeGraph graph) {
        Graph g = (Graph)graph;
        if (g.numVertices() == 0) {
            return true;
        }
        Vertex start = (Vertex)g.getVertices().iterator().next();
        HashSet<Vertex> visited = new HashSet<Vertex>();
        LinkedList<Vertex> stack = new LinkedList<Vertex>();
        stack.add(start);
        while (!stack.isEmpty()) {
            Vertex v = (Vertex)stack.removeFirst();
            visited.add(v);
            Set neighbors = v.getNeighbors();
            Iterator n_it = neighbors.iterator();
            while (n_it.hasNext()) {
                Vertex w = (Vertex)n_it.next();
                if (visited.contains(w)) continue;
                stack.addFirst(w);
            }
        }
        return visited.size() == g.numVertices();
    }

    static {
        message = "connected graph predicate";
    }
}

