/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.TruePredicate;

public class IteratorFactory {
    protected static Map collection_data = new HashMap();

    public static Iterator getIterator(Collection c) {
        IteratorData id = (IteratorData)collection_data.get(c);
        if (id == null) {
            return c.iterator();
        }
        return id.getBackingCollection().iterator();
    }

    public static Iterator getIterator(Collection c, Comparator comp, Predicate p) {
        IteratorData id = new IteratorData(c, comp, p, true);
        return id.getBackingCollection().iterator();
    }

    public static Iterator getIterator(Collection c, Comparator comp) {
        IteratorData id = new IteratorData(c, comp, null, true);
        return id.getBackingCollection().iterator();
    }

    public static Iterator getIterator(Collection c, Predicate p) {
        IteratorData id = new IteratorData(c, null, p, true);
        return id.getBackingCollection().iterator();
    }

    public static void addCollection(Collection c, Comparator comp, Predicate p, boolean dynamic) {
        IteratorData id = new IteratorData(c, comp, p, dynamic);
        collection_data.put(c, id);
    }

    public static void addCollection(Collection c, Comparator comp) {
        IteratorFactory.addCollection(c, comp, null, false);
    }

    public static void addCollection(Collection c, Predicate p) {
        IteratorFactory.addCollection(c, null, p, false);
    }

    public static void addCollection(Collection c, Comparator comp, Predicate p) {
        IteratorFactory.addCollection(c, comp, p, false);
    }

    public static void setDynamic(boolean dynamic, Collection c) {
        IteratorData id = (IteratorData)collection_data.get(c);
        id.setDynamic(dynamic);
    }

    public static void setComparator(Collection c, Comparator comp) {
        IteratorData id = (IteratorData)collection_data.get(c);
        id.setComparator(comp);
    }

    public static void setPredicate(Collection c, Predicate p) {
        IteratorData id = (IteratorData)collection_data.get(c);
        id.setPredicate(p);
    }

    public static void clear() {
        collection_data.clear();
    }

    public static void removeCollection(Collection c) {
        collection_data.remove(c);
    }

    protected static class IteratorData {
        protected boolean is_dynamic;
        protected Collection collection;
        protected Comparator comp;
        protected Collection backing_collection;
        protected Predicate p;

        public IteratorData(Collection c, Comparator comp, Predicate p, boolean dynamic) {
            this.collection = c;
            this.comp = comp;
            this.p = p;
            this.is_dynamic = dynamic;
        }

        public void setComparator(Comparator comp) {
            if (!((Object)this.comp).equals(comp)) {
                this.backing_collection = null;
            }
            this.comp = comp;
        }

        public void setPredicate(Predicate p) {
            if (!this.p.equals(p)) {
                this.backing_collection = null;
            }
            this.p = p;
        }

        public void setDynamic(boolean dynamic) {
            if (!dynamic) {
                this.backing_collection = null;
            }
            this.is_dynamic = dynamic;
        }

        protected Collection getBackingCollection() {
            if (this.is_dynamic) {
                return this.buildBackingCollection(this.collection, this.p, this.comp);
            }
            if (this.backing_collection == null) {
                this.backing_collection = this.buildBackingCollection(this.collection, this.p, this.comp);
            }
            return this.backing_collection;
        }

        protected List buildBackingCollection(Collection c, Predicate p, Comparator comp) {
            ArrayList to_iterate = new ArrayList(c.size());
            if (p != null && p != TruePredicate.getInstance()) {
                Iterator iter = c.iterator();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    if (!p.evaluate(o)) continue;
                    to_iterate.add(o);
                }
            }
            if (comp != null) {
                Collections.sort(to_iterate, comp);
            }
            return to_iterate;
        }
    }
}

