/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.AbstractPickedState;
import edu.uci.ics.jung.visualization.PickEventListener;
import edu.uci.ics.jung.visualization.PickedState;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

public class MultiPickedState
extends AbstractPickedState
implements PickedState {
    protected Set pickedVertices = new LinkedHashSet();
    protected Set pickedEdges = new LinkedHashSet();
    static /* synthetic */ Class class$edu$uci$ics$jung$visualization$PickEventListener;

    public boolean pick(ArchetypeVertex v, boolean picked) {
        boolean prior_state = this.pickedVertices.contains(v);
        if (picked) {
            this.pickedVertices.add(v);
            if (!prior_state) {
                this.firePickEvent(v, true);
                this.fireItemStateChanged(new ItemEvent(this, 701, v, 1));
            }
        } else {
            this.pickedVertices.remove(v);
            if (prior_state) {
                this.firePickEvent(v, false);
                this.fireItemStateChanged(new ItemEvent(this, 701, v, 2));
            }
        }
        return prior_state;
    }

    public boolean pick(ArchetypeEdge e, boolean picked) {
        boolean prior_state = this.pickedEdges.contains(e);
        if (picked) {
            this.pickedEdges.add(e);
            if (!prior_state) {
                this.firePickEvent(e, true);
                this.fireItemStateChanged(new ItemEvent(this, 701, e, 1));
            }
        } else {
            this.pickedEdges.remove(e);
            if (prior_state) {
                this.firePickEvent(e, false);
                this.fireItemStateChanged(new ItemEvent(this, 701, e, 2));
            }
        }
        return prior_state;
    }

    public void clearPickedVertices() {
        LinkedList iterable_set = new LinkedList(this.pickedVertices);
        Iterator it = iterable_set.iterator();
        while (it.hasNext()) {
            this.pick((ArchetypeVertex)it.next(), false);
        }
    }

    public void clearPickedEdges() {
        LinkedList iterable_set = new LinkedList(this.pickedEdges);
        Iterator it = iterable_set.iterator();
        while (it.hasNext()) {
            this.pick((ArchetypeEdge)it.next(), false);
        }
    }

    public Set getPickedEdges() {
        return Collections.unmodifiableSet(this.pickedEdges);
    }

    public boolean isPicked(ArchetypeEdge e) {
        return this.pickedEdges.contains(e);
    }

    public Set getPickedVertices() {
        return Collections.unmodifiableSet(this.pickedVertices);
    }

    public boolean isPicked(ArchetypeVertex v) {
        return this.pickedVertices.contains(v);
    }

    public void addListener(PickEventListener pel) {
        this.listenerList.add(class$edu$uci$ics$jung$visualization$PickEventListener == null ? (class$edu$uci$ics$jung$visualization$PickEventListener = MultiPickedState.class$("edu.uci.ics.jung.visualization.PickEventListener")) : class$edu$uci$ics$jung$visualization$PickEventListener, pel);
    }

    public void removeListener(PickEventListener pel) {
        this.listenerList.remove(class$edu$uci$ics$jung$visualization$PickEventListener == null ? (class$edu$uci$ics$jung$visualization$PickEventListener = MultiPickedState.class$("edu.uci.ics.jung.visualization.PickEventListener")) : class$edu$uci$ics$jung$visualization$PickEventListener, pel);
    }

    public boolean isPicked(Vertex v) {
        return this.pickedVertices.contains(v);
    }

    public boolean isPicked(Edge e) {
        return this.pickedEdges.contains(e);
    }

    public Object[] getSelectedObjects() {
        ArrayList list = new ArrayList(this.pickedVertices);
        list.addAll(this.pickedEdges);
        return list.toArray();
    }

    protected void firePickEvent(Object object, boolean picked) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$uci$ics$jung$visualization$PickEventListener == null ? MultiPickedState.class$("edu.uci.ics.jung.visualization.PickEventListener") : class$edu$uci$ics$jung$visualization$PickEventListener)) continue;
            if (object instanceof Vertex) {
                if (picked) {
                    ((PickEventListener)listeners[i + 1]).vertexPicked((Vertex)object);
                    continue;
                }
                ((PickEventListener)listeners[i + 1]).vertexUnpicked((Vertex)object);
                continue;
            }
            if (picked) {
                ((PickEventListener)listeners[i + 1]).edgePicked((Edge)object);
                continue;
            }
            ((PickEventListener)listeners[i + 1]).edgeUnpicked((Edge)object);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

