/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.Pair;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.Set;
import samples.preview_new_graphdraw.AbstractLayout;
import samples.preview_new_graphdraw.EmittedLayout;
import samples.preview_new_graphdraw.LayoutEmitter;
import samples.preview_new_graphdraw.VisEdge;
import samples.preview_new_graphdraw.VisVertex;

public abstract class StaticLayout
extends AbstractLayout
implements LayoutEmitter {
    public StaticLayout initializeLocations(Dimension d, Graph g) {
        this.setDimensions(d);
        this.createVisVertices(g.getVertices());
        this.createVisEdges(g.getEdges());
        return this;
    }

    protected void createVisVertices(Set vertices) {
        Iterator iter = vertices.iterator();
        while (iter.hasNext()) {
            Vertex v = (Vertex)iter.next();
            VisVertex vv = this.createVisVertex(v);
            this.visVertexMap.put(v, vv);
        }
    }

    protected void createVisEdges(Set edges) {
        Iterator iter = edges.iterator();
        while (iter.hasNext()) {
            Edge e = (Edge)iter.next();
            Pair p = e.getEndpoints();
            Vertex v1 = (Vertex)p.getFirst();
            VisVertex vc1 = this.getVisVertex(v1);
            Vertex v2 = (Vertex)p.getSecond();
            VisVertex vc2 = this.getVisVertex(v2);
            this.visEdgeMap.put(e, this.createVisEdge(e, vc1, vc2));
        }
    }

    protected abstract VisVertex createVisVertex(Vertex var1);

    protected VisEdge createVisEdge(Edge e, VisVertex vv1, VisVertex vv2) {
        return new VisEdge(e, vv1, vv2);
    }

    public EmittedLayout emit() {
        EmittedLayout el = new EmittedLayout();
        el.visEdgeMap = this.visEdgeMap;
        el.visVertexMap = this.visVertexMap;
        el.screenSize = this.screenSize;
        return el;
    }
}

