/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw.transform;

import java.awt.Dimension;
import java.util.Iterator;
import samples.preview_new_graphdraw.Coordinates;
import samples.preview_new_graphdraw.EmittedLayout;
import samples.preview_new_graphdraw.VisVertex;
import samples.preview_new_graphdraw.transform.LayoutTransformer;

public class FitOnScreenTransformer
implements LayoutTransformer {
    private Dimension d;

    protected ScaleAndTranslate checkbounds(EmittedLayout el, Dimension screenSize) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        Iterator iter = el.visVertexMap.values().iterator();
        while (iter.hasNext()) {
            VisVertex vv = (VisVertex)iter.next();
            if (minX > vv.getX()) {
                minX = vv.getX();
            }
            if (minY > vv.getY()) {
                minY = vv.getY();
            }
            if (maxX < vv.getX()) {
                maxX = vv.getX();
            }
            if (!(maxY < vv.getY())) continue;
            maxY = vv.getY();
        }
        return new ScaleAndTranslate(minX, minY, maxX, maxY, screenSize.width, screenSize.height);
    }

    public EmittedLayout transform(EmittedLayout el) {
        ScaleAndTranslate st = this.checkbounds(el, this.d);
        Iterator iter = el.visVertexMap.values().iterator();
        while (iter.hasNext()) {
            VisVertex vv = (VisVertex)iter.next();
            st.relocate(vv);
        }
        return el;
    }

    public void adjustSize(Dimension d) {
        this.d = d;
    }

    public boolean supportsInvert() {
        return true;
    }

    public Coordinates invert(Coordinates in) {
        return this.invert(in);
    }

    public class ScaleAndTranslate {
        private double scaleX;
        private double scaleY;
        private double minX;
        private double minY;

        public ScaleAndTranslate(double minX, double minY, double maxX, double maxY, int xSpace, int ySpace) {
            this.minY = minY;
            this.minX = minX;
            double width = maxX - minX;
            double height = maxY - minY;
            this.scaleX = (double)xSpace / width;
            this.scaleY = (double)ySpace / height;
        }

        public void relocate(VisVertex vv2) {
            vv2.x = this.forwardX(vv2.x);
            vv2.y = this.forwardY(vv2.y);
        }

        public void invert(Coordinates vv) {
            vv.x = vv.x / this.scaleX + this.minX;
            vv.y = vv.y / this.scaleY + this.minY;
        }

        private double forwardY(double d) {
            return (d - this.minY) * this.scaleY;
        }

        private double forwardX(double d) {
            return (d - this.minX) * this.scaleX;
        }
    }
}

