/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.swtgui;

import net.charabia.jsmoothgen.application.JSmoothModelBean;
import net.charabia.jsmoothgen.application.swtgui.JSmoothApplication;
import net.charabia.jsmoothgen.application.swtgui.JSmoothPage;
import net.charabia.jsmoothgen.application.swtgui.resources.JSmoothResources;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExecutablePage
extends JSmoothPage {
    private Text exe;
    private Text dir;
    private Label icon;

    public ExecutablePage(JSmoothApplication js) {
        super(js);
    }

    public Control createPageArea(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(top, 0);
        label.setText("Executable name:");
        GridData grid = new GridData(4);
        label.setLayoutData((Object)grid);
        this.exe = new Text(top, 2048);
        grid = new GridData(768);
        grid.widthHint = 250;
        this.exe.setLayoutData((Object)grid);
        this.exe.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExecutablePage.this.setModelExename(ExecutablePage.this.exe.getText());
            }
        });
        Button button = new Button(top, 0);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ExecutablePage.this.getShell(), 8192);
                dialog.setText("Executable Name");
                String file = dialog.open();
                if (file != null) {
                    ExecutablePage.this.exe.setText(file);
                }
            }
        });
        grid = new GridData(4);
        grid.widthHint = 100;
        button.setLayoutData((Object)grid);
        label = new Label(top, 0);
        label.setText("Current directory:");
        grid = new GridData(4);
        label.setLayoutData((Object)grid);
        this.dir = new Text(top, 2048);
        grid = new GridData(768);
        grid.widthHint = 250;
        this.dir.setLayoutData((Object)grid);
        this.dir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExecutablePage.this.setModelCurrentdir(ExecutablePage.this.dir.getText());
            }
        });
        button = new Button(top, 0);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ExecutablePage.this.getShell(), 8192);
                dialog.setText("Current Directory");
                String dir = dialog.open();
                if (dir != null) {
                    ExecutablePage.this.dir.setText(dir);
                }
            }
        });
        grid = new GridData(4);
        grid.widthHint = 100;
        button.setLayoutData((Object)grid);
        Group group = new Group(top, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        grid = new GridData(68);
        grid.horizontalSpan = 3;
        group.setLayoutData((Object)grid);
        group.setText("Executable icon");
        this.icon = new Label((Composite)group, 0x800800);
        grid = new GridData(68);
        grid.widthHint = 48;
        grid.heightHint = 48;
        this.icon.setLayoutData((Object)grid);
        button = new Button((Composite)group, 0);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ExecutablePage.this.getShell(), 4096);
                dialog.setText("Icon File");
                String file = dialog.open();
                if (file == null) {
                    return;
                }
                ExecutablePage.this.setModelIcon(ExecutablePage.this.setIcon(file) ? file : null);
            }
        });
        grid = new GridData(4);
        grid.widthHint = 100;
        button.setLayoutData((Object)grid);
        return top;
    }

    private void setModelCurrentdir(String dir) {
        System.out.println("[DEBUG] Setting current directory to: " + dir);
        JSmoothModelBean jsmodel = this.getApplication().getModelBean();
        jsmodel.setCurrentDirectory(dir);
    }

    private void setModelExename(String exename) {
        System.out.println("[DEBUG] Setting exe name to: " + exename);
        JSmoothModelBean jsmodel = this.getApplication().getModelBean();
        jsmodel.setExecutableName(exename);
    }

    private boolean setIcon(String file) {
        Image img = null;
        img = this.icon.getImage();
        if (img != null) {
            this.icon.setImage(null);
            img.dispose();
        }
        if (file == null || file.equals("")) {
            return true;
        }
        try {
            img = new Image((Device)this.getShell().getDisplay(), file);
            ImageData data = img.getImageData();
            if (data.width > 48 && data.height > 48) {
                System.out.println("[DEBUG] The image size is too big, > 48x48");
                return false;
            }
        }
        catch (SWTException e) {
            System.out.println("[ERROR] " + e.getMessage());
            return false;
        }
        this.icon.setImage(img);
        return true;
    }

    private void setModelIcon(String iconfile) {
        System.out.println("[DEBUG] Setting icon file to: " + iconfile);
        JSmoothModelBean jsmodel = this.getApplication().getModelBean();
        jsmodel.setIconLocation(iconfile);
    }

    protected void configureResources() {
        this.setImage(JSmoothResources.IMG_SWITCHER_EXECUTABLE);
        this.setToolTip("Windows Executable");
    }

    public void load() {
        JSmoothModelBean jsmodel = this.getApplication().getModelBean();
        String exename = jsmodel.getExecutableName();
        if (exename == null) {
            exename = "";
        }
        this.exe.setText(exename);
        String iconfile = jsmodel.getIconLocation();
        this.setIcon(iconfile);
        String dirname = jsmodel.getCurrentDirectory();
        if (dirname == null) {
            dirname = "";
        }
        this.dir.setText(dirname);
    }
}

