/*
 * Decompiled with CFR 0.152.
 */
package net.roydesign.mac;

import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJOpenApplicationHandler;
import com.apple.mrj.MRJOpenDocumentHandler;
import com.apple.mrj.MRJPrefsHandler;
import com.apple.mrj.MRJPrintDocumentHandler;
import com.apple.mrj.MRJQuitHandler;
import java.io.File;
import net.roydesign.mac.AppleEventHandler;
import net.roydesign.mac.JD2AppleEventFunctions;
import net.roydesign.mac.JD2AppleEventHandlerThunk;
import net.roydesign.mac.JD3AppleEventHandlerThunk;
import net.roydesign.mac.JD3CarbonFunctions;
import net.roydesign.mac.MRJAdapter;
import net.roydesign.mac.MRJEventProxy;

class MRJ23EventProxy
extends MRJEventProxy {
    private static final int kCoreEventClass = 1634039412;
    private static final int kPreferencesItem = 1886545254;
    private static final int kReopenApplicationEvent = 1918988400;
    private static MRJ23EventProxy instance;
    private Object preferencesHandler;
    private Object reopenApplicationHandler;
    private boolean preferencesEnabled = false;

    public static MRJ23EventProxy getInstance() {
        if (instance == null) {
            instance = new MRJ23EventProxy();
        }
        return instance;
    }

    private MRJ23EventProxy() {
        Handler h = new Handler();
        MRJApplicationUtils.registerAboutHandler((MRJAboutHandler)h);
        MRJApplicationUtils.registerOpenApplicationHandler((MRJOpenApplicationHandler)h);
        MRJApplicationUtils.registerOpenDocumentHandler((MRJOpenDocumentHandler)h);
        MRJApplicationUtils.registerPrintDocumentHandler((MRJPrintDocumentHandler)h);
        MRJApplicationUtils.registerQuitHandler((MRJQuitHandler)h);
        if (MRJAdapter.mrjVersion >= 3.2f) {
            this.preferencesHandler = new MRJPrefsHandler(){

                public void handlePrefs() {
                    MRJ23EventProxy.this.fireMenuEvent(2);
                }
            };
        } else if (MRJAdapter.mrjVersion >= 3.0f) {
            this.preferencesHandler = new JD3AppleEventHandlerThunk(new AppleEventHandler(){

                public short handleEvent(int event, int reply, int refcon) {
                    new Thread(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            2.access$100(this.this$1).fireMenuEvent(2);
                        }
                    }.start();
                    return 0;
                }

                static /* synthetic */ MRJ23EventProxy access$100(2 x0) {
                    return x0.MRJ23EventProxy.this;
                }
            });
            JD3CarbonFunctions.AEInstallEventHandler(1634039412, 1886545254, ((JD3AppleEventHandlerThunk)((Object)this.preferencesHandler)).getProc(), 0, false);
        }
        if (MRJAdapter.mrjVersion >= 2.1f) {
            AppleEventHandler aeh = new AppleEventHandler(){

                public short handleEvent(int event, int reply, int refcon) {
                    new Thread(this){
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            4.access$200(this.this$1).fireApplicationEvent(7);
                        }
                    }.start();
                    return 0;
                }

                static /* synthetic */ MRJ23EventProxy access$200(4 x0) {
                    return x0.MRJ23EventProxy.this;
                }
            };
            if (MRJAdapter.mrjVersion >= 3.0f) {
                this.reopenApplicationHandler = new JD3AppleEventHandlerThunk(aeh);
                JD3CarbonFunctions.AEInstallEventHandler(1634039412, 1918988400, ((JD3AppleEventHandlerThunk)((Object)this.reopenApplicationHandler)).getProc(), 0, false);
            } else {
                this.reopenApplicationHandler = new JD2AppleEventHandlerThunk(aeh);
                JD2AppleEventFunctions.AEInstallEventHandler(1634039412, 1918988400, ((JD2AppleEventHandlerThunk)((Object)this.reopenApplicationHandler)).getProc(), 0, false);
            }
        }
    }

    public boolean isPreferencesEnabled() {
        return this.preferencesEnabled;
    }

    public void setPreferencesEnabled(boolean enabled) {
        if (enabled != this.preferencesEnabled) {
            if (MRJAdapter.mrjVersion >= 3.2f) {
                if (enabled) {
                    MRJApplicationUtils.registerPrefsHandler((MRJPrefsHandler)((MRJPrefsHandler)this.preferencesHandler));
                } else {
                    MRJApplicationUtils.registerPrefsHandler(null);
                }
            } else if (MRJAdapter.mrjVersion >= 3.0f) {
                if (enabled) {
                    JD3CarbonFunctions.EnableMenuCommand(0, 1886545254);
                } else {
                    JD3CarbonFunctions.DisableMenuCommand(0, 1886545254);
                }
            }
            this.preferencesEnabled = enabled;
        }
    }

    private class Handler
    implements MRJAboutHandler,
    MRJOpenApplicationHandler,
    MRJOpenDocumentHandler,
    MRJPrintDocumentHandler,
    MRJQuitHandler {
        private Handler() {
        }

        public void handleAbout() {
            MRJ23EventProxy.this.fireMenuEvent(1);
        }

        public void handleOpenApplication() {
            MRJ23EventProxy.this.fireApplicationEvent(3);
        }

        public void handleQuit() {
            MRJ23EventProxy.this.fireApplicationEvent(4);
            if (MRJAdapter.mrjVersion >= 3.0f) {
                throw new IllegalStateException();
            }
        }

        public void handleOpenFile(File file) {
            MRJ23EventProxy.this.fireDocumentEvent(5, file);
        }

        public void handlePrintFile(File file) {
            MRJ23EventProxy.this.fireDocumentEvent(6, file);
        }
    }
}

