/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.swingui.Constants;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RuleSetReader
implements Constants {
    private RuleSet m_ruleSet;
    private boolean m_onlyIfIncluded;
    private final String REJECT_NOT_INCLUDED = "Reject not included";

    public RuleSet read(InputStream inputStream, String ruleSetFileName) throws PMDException {
        return this.read(inputStream, ruleSetFileName, false);
    }

    public RuleSet read(InputStream inputStream, String ruleSetFileName, boolean onlyIfIncluded) throws PMDException {
        if (inputStream == null) {
            String message = "Missing input stream.";
            PMDException pmdException = new PMDException(message);
            pmdException.fillInStackTrace();
            throw pmdException;
        }
        if (ruleSetFileName == null) {
            String message = "Missing rule set file name.";
            PMDException pmdException = new PMDException(message);
            pmdException.fillInStackTrace();
            throw pmdException;
        }
        this.m_onlyIfIncluded = onlyIfIncluded;
        try {
            InputSource inputSource = new InputSource(inputStream);
            MainContentHandler mainContentHandler = new MainContentHandler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            factory.setFeature("http://xml.org/sax/features/namespaces", false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(inputSource, (DefaultHandler)mainContentHandler);
            this.m_ruleSet.setFileName(ruleSetFileName);
            return this.m_ruleSet;
        }
        catch (IOException exception) {
            PMDException pmdException = new PMDException("IOException was thrown.", exception);
            pmdException.fillInStackTrace();
            throw pmdException;
        }
        catch (SAXException exception) {
            if (exception.getMessage() == "Reject not included") {
                return null;
            }
            Exception originalException = exception.getException();
            if (originalException instanceof PMDException) {
                throw (PMDException)originalException;
            }
            String message = "SAXException was thrown.";
            PMDException pmdException = new PMDException(message, exception);
            pmdException.fillInStackTrace();
            throw pmdException;
        }
        catch (Exception exception) {
            PMDException pmdException = new PMDException("Uncaught exception was thrown.", exception);
            pmdException.fillInStackTrace();
            throw pmdException;
        }
    }

    private class MainContentHandler
    extends DefaultHandler {
        private StringBuffer m_buffer = new StringBuffer(500);
        private Rule m_rule;

        private MainContentHandler() {
        }

        public void startElement(String namespace, String localName, String qualifiedName, Attributes attributes) throws SAXException {
            this.m_buffer.setLength(0);
            if (qualifiedName.equalsIgnoreCase("ruleset")) {
                RuleSetReader.this.m_ruleSet = new RuleSet();
                String name = attributes.getValue("name");
                name = name == null ? "Unknown" : name.trim();
                String include = attributes.getValue("include");
                include = include == null ? "true" : include.trim();
                RuleSetReader.this.m_ruleSet.setName(name);
                RuleSetReader.this.m_ruleSet.setInclude(include.equalsIgnoreCase("true"));
            } else if (qualifiedName.equalsIgnoreCase("rule")) {
                String ruleName = attributes.getValue("name");
                String message = attributes.getValue("message");
                String className = attributes.getValue("class");
                String includeText = attributes.getValue("include");
                ruleName = ruleName == null ? "Unknown" : ruleName.trim();
                message = message == null ? "" : message.trim();
                className = className == null ? "" : className.trim();
                includeText = includeText == null ? "true" : includeText.trim();
                boolean include = includeText.equalsIgnoreCase("true");
                if (RuleSetReader.this.m_onlyIfIncluded && !include) {
                    SAXException exception = new SAXException("Reject not included");
                    throw exception;
                }
                if (className.length() == 0) {
                    String template = "Missing class name for rule \"{0}\" in rule set \"{1}\".";
                    Object[] args = new Object[]{ruleName, RuleSetReader.this.m_ruleSet.getName()};
                    String msg = MessageFormat.format(template, args);
                    PMDException pmdException = new PMDException(msg);
                    SAXException saxException = new SAXException("", pmdException.getReason());
                    pmdException.fillInStackTrace();
                    throw saxException;
                }
                try {
                    Class<?> ruleClass = Class.forName(className);
                    this.m_rule = (Rule)ruleClass.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        className = "net.sourceforge.pmd.UndefinedRule";
                        Class<?> ruleClass = Class.forName(className);
                        this.m_rule = (Rule)ruleClass.newInstance();
                    }
                    catch (Exception exception) {
                        String template = "Cannot find class \"{0}\" on the classpath.";
                        Object[] args = new Object[]{className};
                        String msg = MessageFormat.format(template, args);
                        PMDException pmdException = new PMDException(msg, exception);
                        SAXException saxException = new SAXException("", pmdException);
                        pmdException.fillInStackTrace();
                        throw saxException;
                    }
                }
                catch (IllegalAccessException exception) {
                    String template = "Illegal access to class \"{0}\" for rule \"{1}\" in rule set \"{2}\".";
                    Object[] args = new Object[]{className, ruleName, RuleSetReader.this.m_ruleSet.getName()};
                    String msg = MessageFormat.format(template, args);
                    PMDException pmdException = new PMDException(msg, exception);
                    SAXException saxException = new SAXException("", pmdException);
                    pmdException.fillInStackTrace();
                    throw saxException;
                }
                catch (InstantiationException exception) {
                    String template = "Cannot instantiate class \"{0}\" for rule \"{1}\" in rule set \"{2}\".";
                    Object[] args = new Object[]{className, ruleName, RuleSetReader.this.m_ruleSet.getName()};
                    String msg = MessageFormat.format(template, args);
                    PMDException pmdException = new PMDException(msg, exception);
                    SAXException saxException = new SAXException("", pmdException);
                    pmdException.fillInStackTrace();
                    throw saxException;
                }
                this.m_rule.setName(ruleName);
                this.m_rule.setMessage(message);
                this.m_rule.setInclude(include);
                RuleSetReader.this.m_ruleSet.addRule(this.m_rule);
            } else if (qualifiedName.equalsIgnoreCase("property")) {
                String name = attributes.getValue("name");
                String value = attributes.getValue("value");
                String type = attributes.getValue("type");
                name = name == null ? "" : name.trim();
                value = value == null ? "" : value;
                String string = type = type == null ? "" : type;
                if (name.length() > 0) {
                    this.m_rule.getProperties().setValue(name, value);
                    this.m_rule.getProperties().setValueType(name, type);
                }
            }
        }

        public void characters(char[] chars, int beginIndex, int length) {
            this.m_buffer.append(chars, beginIndex, length);
        }

        public void endElement(String namespace, String localName, String qualifiedName) throws SAXException {
            if (qualifiedName.equalsIgnoreCase("description")) {
                if (this.m_rule == null) {
                    RuleSetReader.this.m_ruleSet.setDescription(this.trim(this.m_buffer));
                } else {
                    this.m_rule.setDescription(this.trim(this.m_buffer));
                }
            } else if (qualifiedName.equalsIgnoreCase("message")) {
                this.m_rule.setMessage(this.trim(this.m_buffer));
            } else if (qualifiedName.equalsIgnoreCase("example")) {
                this.m_rule.setExample(this.trimExample(this.m_buffer));
            } else if (qualifiedName.equals("priority")) {
                int priority;
                try {
                    priority = Integer.parseInt(this.trim(this.m_buffer));
                }
                catch (NumberFormatException exception) {
                    priority = 5;
                }
                this.m_rule.setPriority(priority);
            } else if (qualifiedName.equalsIgnoreCase("rule")) {
                this.m_rule = null;
            }
        }

        private String trim(StringBuffer buffer) {
            if (buffer.length() > 0) {
                int n = buffer.length() - 1;
                while (n >= 0) {
                    char theChar;
                    if (buffer.charAt(n) == '\n') {
                        buffer.setCharAt(n, ' ');
                    }
                    if ((theChar = buffer.charAt(n)) == ' ') {
                        if (n == buffer.length() - 1) {
                            buffer.deleteCharAt(n);
                        } else if (buffer.charAt(n + 1) == ' ') {
                            buffer.deleteCharAt(n);
                        } else if (n == 0) {
                            buffer.deleteCharAt(n);
                        }
                    }
                    --n;
                }
            }
            return buffer.toString();
        }

        private String trimExample(StringBuffer buffer) {
            while (buffer.length() > 0 && (buffer.charAt(0) == '\n' || buffer.charAt(0) == ' ')) {
                buffer.deleteCharAt(0);
            }
            int n = buffer.length() - 1;
            while (n >= 0) {
                if (buffer.charAt(n) != '\n' && buffer.charAt(n) != ' ') {
                    buffer.setLength(n + 1);
                    break;
                }
                --n;
            }
            return buffer.toString();
        }
    }
}

