/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

public class TokenEntry
implements Comparable {
    public static final TokenEntry EOF = new TokenEntry();
    private char[] chars;
    private int hash;
    private String image;
    private int index;
    private String tokenSrcID;
    private int beginLine;
    private int sortCode;

    private TokenEntry() {
        this.image = "EOF";
        this.chars = this.image.toCharArray();
        this.tokenSrcID = "EOFMarker";
    }

    public TokenEntry(String image, int index, String tokenSrcID, int beginLine) {
        this.image = image;
        this.index = index;
        this.tokenSrcID = tokenSrcID;
        this.beginLine = beginLine;
        this.chars = image.toCharArray();
    }

    public int getIndex() {
        return this.index;
    }

    public String getTokenSrcID() {
        return this.tokenSrcID;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public void setSortCode(int code) {
        this.sortCode = code;
    }

    public boolean equals(Object o) {
        if (o instanceof TokenEntry) {
            TokenEntry token = (TokenEntry)o;
            if (this == EOF) {
                return token == EOF;
            }
            if (token.image.length() != this.image.length()) {
                return false;
            }
            int i = 0;
            while (i < this.image.length()) {
                if (this.chars[i] != token.chars[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            if (this == EOF) {
                h = -1;
            } else {
                int i = 0;
                while (i < this.image.length()) {
                    h = 37 * h + this.chars[i];
                    ++i;
                }
            }
            this.hash = h;
        }
        return h;
    }

    public int compareTo(Object o) {
        TokenEntry token = (TokenEntry)o;
        if (this == EOF) {
            if (token == EOF) {
                return 0;
            }
            return -1;
        }
        if (this.sortCode > 0 && token.sortCode > 0) {
            return this.sortCode - token.sortCode;
        }
        if (this.image.length() == token.image.length()) {
            int i = 0;
            while (i < this.image.length() && i < token.image.length()) {
                char c1 = this.chars[i];
                char c2 = token.chars[i];
                if (c1 != c2) {
                    return c1 - c2;
                }
                ++i;
            }
            return 0;
        }
        int i = 0;
        while (i < this.image.length() && i < token.image.length()) {
            char c1 = this.chars[i];
            char c2 = token.chars[i];
            if (c1 != c2) {
                return c1 - c2;
            }
            ++i;
        }
        return this.image.length() - token.image.length();
    }
}

