/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.tree.TreeNode;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.swingui.ComponentFactory;
import net.sourceforge.pmd.swingui.HelpMenu;
import net.sourceforge.pmd.swingui.MessageDialog;
import net.sourceforge.pmd.swingui.PMDViewer;
import net.sourceforge.pmd.swingui.Preferences;
import net.sourceforge.pmd.swingui.RuleEditingTabbedPane;
import net.sourceforge.pmd.swingui.RulesTree;
import net.sourceforge.pmd.swingui.RulesTreeNode;
import net.sourceforge.pmd.swingui.event.ListenerList;
import net.sourceforge.pmd.swingui.event.RuleSetChangedEvent;
import net.sourceforge.pmd.swingui.event.RuleSetEvent;
import net.sourceforge.pmd.swingui.event.RulesInMemoryEvent;
import net.sourceforge.pmd.swingui.event.RulesInMemoryEventListener;
import net.sourceforge.pmd.swingui.event.RulesTreeModelEvent;
import net.sourceforge.pmd.swingui.event.RulesTreeModelEventListener;

class RulesEditor
extends JPanel {
    private RulesTree m_tree = new RulesTree();
    private JSplitPane m_splitPane;
    private RuleEditingTabbedPane m_editingTabbedPane;
    private JMenuBar m_menuBar;
    private JMenuItem m_printSelectedRuleMenuItem;

    protected RulesEditor() throws PMDException {
        super(new BorderLayout());
        JScrollPane treeScrollPane = this.createTreeScrollPane();
        this.m_editingTabbedPane = new RuleEditingTabbedPane(this.m_tree);
        this.m_splitPane = ComponentFactory.createHorizontalSplitPane(treeScrollPane, this.m_editingTabbedPane);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)this.m_splitPane, "Center");
        this.add((Component)contentPanel, "Center");
        this.createMenuBar();
        ListenerList.addListener(new RulesInMemoryEventHandler());
    }

    private JScrollPane createTreeScrollPane() {
        JScrollPane scrollPane = ComponentFactory.createScrollPane(this.m_tree);
        Color background = UIManager.getColor("pmdTreeBackground");
        scrollPane.getViewport().setBackground(background);
        return scrollPane;
    }

    private void createMenuBar() {
        this.m_menuBar = new JMenuBar();
        this.m_menuBar.add(new FileMenu());
        this.m_menuBar.add(new HelpMenu());
    }

    public void adjustSplitPaneDividerLocation() {
        this.m_splitPane.setDividerLocation(0.4);
    }

    protected void setMenuBar() {
        PMDViewer.getViewer().setJMenuBar(this.m_menuBar);
    }

    protected void saveData() {
        this.m_editingTabbedPane.saveData();
        this.saveData((RulesTreeNode)this.m_tree.getModel().getRoot());
    }

    private void saveData(RulesTreeNode treeNode) {
        treeNode.saveData();
        Enumeration<TreeNode> children = treeNode.children();
        while (children.hasMoreElements()) {
            this.saveData((RulesTreeNode)children.nextElement());
        }
    }

    private class IncludeSelectedRuleFilter
    extends RuleFilter {
        private int m_lowestPriority;

        private IncludeSelectedRuleFilter(int lowestPriority) {
            this.m_lowestPriority = lowestPriority;
        }

        protected boolean include(RulesTreeNode treeNode) {
            return treeNode.include() && treeNode.getPriority() <= this.m_lowestPriority;
        }
    }

    private class IncludeAllRuleFilter
    extends RuleFilter {
        private IncludeAllRuleFilter() {
        }

        protected boolean include(RulesTreeNode treeNode) {
            return true;
        }
    }

    private abstract class RuleFilter {
        private RuleFilter() {
        }

        protected abstract boolean include(RulesTreeNode var1);
    }

    private class RulesInMemoryEventHandler
    implements RulesInMemoryEventListener {
        private RulesInMemoryEventHandler() {
        }

        public void requestAllRules(RulesInMemoryEvent event) {
            RuleSet rules = new RuleSet();
            RulesTreeNode rootNode = (RulesTreeNode)RulesEditor.this.m_tree.getModel().getRoot();
            this.getRules(rootNode, rules, new IncludeAllRuleFilter());
            RulesInMemoryEvent.notifyReturnedRules(this, rules);
        }

        public void requestIncludedRules(RulesInMemoryEvent event) {
            try {
                RuleSet rules = new RuleSet();
                RulesTreeNode rootNode = (RulesTreeNode)RulesEditor.this.m_tree.getModel().getRoot();
                int lowestPriority = Preferences.getPreferences().getLowestPriorityForAnalysis();
                this.getRules(rootNode, rules, new IncludeSelectedRuleFilter(lowestPriority));
                RulesInMemoryEvent.notifyReturnedRules(this, rules);
            }
            catch (PMDException pmdException) {
                String message = pmdException.getMessage();
                Exception exception = pmdException.getReason();
                MessageDialog.show(PMDViewer.getViewer(), message, exception);
            }
        }

        private void getRules(RulesTreeNode rootNode, RuleSet rules, RuleFilter ruleFilter) {
            Enumeration<TreeNode> ruleSetNodes = rootNode.children();
            while (ruleSetNodes.hasMoreElements()) {
                RulesTreeNode ruleSetNode = (RulesTreeNode)ruleSetNodes.nextElement();
                if (!ruleFilter.include(ruleSetNode)) continue;
                Enumeration<TreeNode> ruleNodes = ruleSetNode.children();
                while (ruleNodes.hasMoreElements()) {
                    RulesTreeNode ruleNode = (RulesTreeNode)ruleNodes.nextElement();
                    if (!ruleFilter.include(ruleNode)) continue;
                    rules.addRule(ruleNode.getRule());
                }
            }
        }

        public void returnedRules(RulesInMemoryEvent event) {
        }
    }

    private class FileMenuMouseListener
    extends MouseAdapter
    implements RulesTreeModelEventListener {
        private Rule m_rule;

        private FileMenuMouseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseEntered(MouseEvent event) {
            try {
                ListenerList.addListener(this);
                RulesTreeModelEvent.notifyRequestSelectedRule(this);
                boolean enable = this.m_rule != null;
                RulesEditor.this.m_printSelectedRuleMenuItem.setEnabled(enable);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ListenerList.removeListener(this);
                throw throwable;
            }
            ListenerList.removeListener(this);
        }

        public void reload(RulesTreeModelEvent event) {
        }

        public void requestSelectedRule(RulesTreeModelEvent event) {
        }

        public void returnedSelectedRule(RulesTreeModelEvent event) {
            this.m_rule = event.getRule();
        }
    }

    private class ExitActionListener
    implements ActionListener {
        private ExitActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            System.exit(0);
        }
    }

    private class PageSetupActionListener
    implements ActionListener {
        private PageSetupActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MessageDialog.show(PMDViewer.getViewer(), "Page setup not available yet.");
        }
    }

    private class PrintRulesActionListener
    implements ActionListener {
        private PrintRulesActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MessageDialog.show(PMDViewer.getViewer(), "Printing not available yet.");
        }
    }

    private class FileMenu
    extends JMenu {
        private FileMenu() {
            super("File");
            this.setMnemonic('F');
            Icon icon = UIManager.getIcon("save");
            JMenuItem menuItem = new JMenuItem("Save Changes", icon);
            menuItem.addActionListener(new SaveActionListener());
            menuItem.setMnemonic('S');
            menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
            this.add(menuItem);
            icon = UIManager.getIcon("cancel");
            menuItem = new JMenuItem("Cancel Changes", icon);
            menuItem.addActionListener(new CancelActionListener());
            menuItem.setMnemonic('C');
            menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            this.add(menuItem);
            this.add(new JSeparator());
            icon = UIManager.getIcon("print");
            menuItem = new JMenuItem("Print Rules...", icon);
            menuItem.addActionListener(new PrintRulesActionListener());
            menuItem.setMnemonic('R');
            menuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
            this.add(menuItem);
            icon = UIManager.getIcon("print");
            RulesEditor.this.m_printSelectedRuleMenuItem = new JMenuItem("Print Selected Rule...", icon);
            RulesEditor.this.m_printSelectedRuleMenuItem.addActionListener(new PrintRulesActionListener());
            RulesEditor.this.m_printSelectedRuleMenuItem.setMnemonic('E');
            RulesEditor.this.m_printSelectedRuleMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
            this.add(RulesEditor.this.m_printSelectedRuleMenuItem);
            menuItem = new JMenuItem("Page Setup...");
            menuItem.addActionListener(new PageSetupActionListener());
            menuItem.setMnemonic('A');
            menuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
            this.add(menuItem);
            this.add(new JSeparator());
            menuItem = new JMenuItem("Exit...");
            menuItem.addActionListener(new ExitActionListener());
            menuItem.setMnemonic('X');
            this.add(menuItem);
            this.addMouseListener(new FileMenuMouseListener());
        }
    }

    private class CancelActionListener
    implements ActionListener {
        private CancelActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            RulesEditor.this.setVisible(false);
        }
    }

    private class SaveActionListener
    implements ActionListener {
        private SaveActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            RulesEditor.this.saveData();
            this.writeRuleSets((RulesTreeNode)RulesEditor.this.m_tree.getModel().getRoot());
            RuleSetChangedEvent.notifyRuleSetsChanged(this);
        }

        private void writeRuleSets(RulesTreeNode rootNode) {
            ArrayList<RuleSet> ruleSetList = new ArrayList<RuleSet>();
            Enumeration<TreeNode> ruleSetNodes = rootNode.children();
            while (ruleSetNodes.hasMoreElements()) {
                RulesTreeNode ruleSetNode = (RulesTreeNode)ruleSetNodes.nextElement();
                RuleSet ruleSet = ruleSetNode.getRuleSet();
                Enumeration<TreeNode> ruleNodes = ruleSetNode.children();
                ruleSetList.add(ruleSet);
                ruleSet.getRules().clear();
                while (ruleNodes.hasMoreElements()) {
                    RulesTreeNode ruleNode = (RulesTreeNode)ruleNodes.nextElement();
                    ruleSet.addRule(ruleNode.getRule());
                }
            }
            RuleSetEvent.notifySaveRuleSets(this, ruleSetList);
        }
    }
}

