/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeNode;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.swingui.ComponentFactory;
import net.sourceforge.pmd.swingui.DirectoryTree;
import net.sourceforge.pmd.swingui.DirectoryTreeNode;
import net.sourceforge.pmd.swingui.HelpMenu;
import net.sourceforge.pmd.swingui.MessageDialog;
import net.sourceforge.pmd.swingui.PMDViewer;
import net.sourceforge.pmd.swingui.Preferences;
import net.sourceforge.pmd.swingui.PrintAnalysisResults;
import net.sourceforge.pmd.swingui.RulesTree;
import net.sourceforge.pmd.swingui.RulesTreeNode;
import net.sourceforge.pmd.swingui.SearchResultsViewer;
import net.sourceforge.pmd.swingui.StatusBar;
import net.sourceforge.pmd.swingui.event.DirectoryTableEvent;
import net.sourceforge.pmd.swingui.event.DirectoryTableEventListener;
import net.sourceforge.pmd.swingui.event.HTMLAnalysisResultsEvent;
import net.sourceforge.pmd.swingui.event.HTMLAnalysisResultsEventListener;
import net.sourceforge.pmd.swingui.event.ListenerList;
import net.sourceforge.pmd.swingui.event.TextAnalysisResultsEvent;
import net.sourceforge.pmd.swingui.event.TextAnalysisResultsEventListener;

class SearchViewer
extends JPanel {
    private DirectoryTree m_directoryTree;
    private StatusBar m_statusBar;
    private JPanel m_directoryTreePanel;
    private RulesTree m_rulesTree;
    private JPanel m_rulesTreePanel;
    private JSplitPane m_directoryRuleSplitPane;
    private SearchResultsViewer m_resultsViewer;
    private JPanel m_resultsViewerPanel;
    private JSplitPane m_mainSplitPane;
    private JButton m_searchButton;
    private JPanel m_buttonPanel;
    private JMenuBar m_menuBar;
    private PMDClipboard m_clipboardOwner = new PMDClipboard();
    private JMenuItem m_saveMenuItem;
    private JMenuItem m_saveAsMenuItem;
    private JMenuItem m_printAnalysisMenuItem;
    private JMenuItem m_copyHTMLResultsMenuItem;
    private JMenuItem m_copyTextResultsMenuItem;

    protected SearchViewer() throws PMDException {
        super(new BorderLayout());
        this.createStatusBar();
        this.createDirectoryTreePanel();
        this.createRulesTreePanel();
        this.createDirectoryRuleSplitPane();
        this.createResultsViewer();
        this.createResultsViewerScrollPane();
        this.createMainSplitPane();
        this.createButtonPanel();
        this.createMenuBar();
        this.setMenuBar();
        this.add(this.createContentPanel(10));
    }

    private void createStatusBar() {
        String defaultMessage = "Select a source file directory and a rule to view the analysis below.";
        this.m_statusBar = new StatusBar(defaultMessage);
        EmptyBorder emptyBorder = new EmptyBorder(0, 0, 5, 0);
        CompoundBorder compoundBorder = new CompoundBorder(emptyBorder, this.m_statusBar.getBorder());
        this.m_statusBar.setBorder(compoundBorder);
    }

    private void createDirectoryTreePanel() {
        this.m_directoryTree = new DirectoryTree("File Directories");
        JScrollPane scrollPane = ComponentFactory.createScrollPane(this.m_directoryTree);
        Color background = UIManager.getColor("pmdTreeBackground");
        scrollPane.getViewport().setBackground(background);
        this.m_directoryTreePanel = new JPanel(new BorderLayout());
        this.m_directoryTreePanel.setBorder(this.createTitledBorder(" Directory "));
        this.m_directoryTreePanel.add((Component)scrollPane, "Center");
    }

    private void createRulesTreePanel() throws PMDException {
        this.m_rulesTree = new RulesTree();
        this.m_rulesTree.setDisablePopupMenu(true);
        this.m_rulesTree.setDisableEditing(true);
        this.m_rulesTree.expandNode(this.m_rulesTree.getRootNode());
        JScrollPane scrollPane = ComponentFactory.createScrollPane(this.m_rulesTree);
        Color background = UIManager.getColor("pmdTableBackground");
        scrollPane.getViewport().setBackground(background);
        this.m_rulesTreePanel = new JPanel(new BorderLayout());
        this.m_rulesTreePanel.setBorder(this.createTitledBorder(" Rule "));
        this.m_rulesTreePanel.add((Component)scrollPane, "Center");
    }

    private void createDirectoryRuleSplitPane() {
        this.m_directoryRuleSplitPane = ComponentFactory.createHorizontalSplitPane(this.m_directoryTreePanel, this.m_rulesTreePanel);
    }

    private void createResultsViewer() {
        this.m_resultsViewer = new SearchResultsViewer();
        this.m_resultsViewer.setSelectionColor(Color.blue);
    }

    private void createResultsViewerScrollPane() {
        JScrollPane scrollPane = ComponentFactory.createScrollPane(this.m_resultsViewer);
        this.m_resultsViewerPanel = new JPanel(new BorderLayout());
        this.m_resultsViewerPanel.setBorder(this.createTitledBorder(" Search Results "));
        this.m_resultsViewerPanel.add((Component)scrollPane, "Center");
    }

    private void createMainSplitPane() {
        this.m_mainSplitPane = ComponentFactory.createVerticalSplitPane(this.m_directoryRuleSplitPane, this.m_resultsViewerPanel);
    }

    private void createButtonPanel() {
        this.m_buttonPanel = ComponentFactory.createButtonPanel();
        Color background = UIManager.getColor("pmdBlue");
        this.m_searchButton = ComponentFactory.createButton("Search", background, Color.white);
        this.m_searchButton.addActionListener(new SearchButtonActionEventHandler());
        this.m_buttonPanel.add(this.m_searchButton);
    }

    private JPanel createContentPanel(int margin) {
        JPanel contentPanel = new JPanel(new BorderLayout());
        EtchedBorder outsideBorder = new EtchedBorder(0);
        EmptyBorder insideBorder = new EmptyBorder(margin, margin, margin, margin);
        CompoundBorder compoundBorder = new CompoundBorder(outsideBorder, insideBorder);
        contentPanel.setBorder(compoundBorder);
        contentPanel.add((Component)this.m_statusBar, "North");
        contentPanel.add((Component)this.m_mainSplitPane, "Center");
        contentPanel.add((Component)this.m_buttonPanel, "South");
        return contentPanel;
    }

    private TitledBorder createTitledBorder(String title) {
        EtchedBorder etchedBorder = new EtchedBorder(0);
        TitledBorder titledBorder = new TitledBorder(etchedBorder, title);
        Font font = titledBorder.getTitleFont();
        font = new Font(font.getName(), 1, font.getSize());
        titledBorder.setTitleFont(font);
        return titledBorder;
    }

    protected void adjustSplitPaneDividerLocation() {
        this.m_mainSplitPane.setDividerLocation(0.4);
        this.m_directoryRuleSplitPane.setDividerLocation(0.5);
    }

    private void createMenuBar() {
        this.m_menuBar = new JMenuBar();
        this.m_menuBar.add(new FileMenu());
        this.m_menuBar.add(new EditMenu());
        this.m_menuBar.add(new HelpMenu());
    }

    protected void setMenuBar() {
        PMDViewer.getViewer().setJMenuBar(this.m_menuBar);
    }

    protected void analyze() {
        this.m_resultsViewer.analyze();
    }

    private class SearchButtonActionEventHandler
    implements ActionListener {
        private SearchButtonActionEventHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            RuleSet ruleSet;
            RulesTreeNode rulesNode = SearchViewer.this.m_rulesTree.getSelectedNode();
            if (rulesNode.isRoot()) {
                ruleSet = new RuleSet();
                Enumeration<TreeNode> ruleSets = rulesNode.children();
                while (ruleSets.hasMoreElements()) {
                    RulesTreeNode childNode = (RulesTreeNode)ruleSets.nextElement();
                    ruleSet.addRuleSet(childNode.getRuleSet());
                }
            } else if (rulesNode.isRuleSet()) {
                ruleSet = rulesNode.getRuleSet();
            } else if (rulesNode.isRule()) {
                ruleSet = new RuleSet();
                ruleSet.addRule(rulesNode.getRule());
            } else {
                rulesNode = (RulesTreeNode)rulesNode.getParent();
                ruleSet = new RuleSet();
                ruleSet.addRule(rulesNode.getRule());
            }
            DirectoryTreeNode directoryNode = SearchViewer.this.m_directoryTree.getSelectedNode();
            File directory = (File)directoryNode.getUserObject();
            SearchViewer.this.m_resultsViewer.analyze(directory, ruleSet);
        }
    }

    private class PMDClipboard
    implements ClipboardOwner {
        private PMDClipboard() {
        }

        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }

    private class HTMLFileFilter
    extends FileFilter {
        private HTMLFileFilter() {
        }

        public boolean accept(File file) {
            String fileName = file.getName();
            return fileName.endsWith(".html") || fileName.endsWith(".htm");
        }

        public String getDescription() {
            return "HTML Anaysis Result File (*.html, *.htm)";
        }
    }

    private class SaveAsActionListener
    implements ActionListener,
    DirectoryTableEventListener {
        private File m_selectedFile;

        private SaveAsActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(ActionEvent event) {
            try {
                block5: {
                    try {
                        ListenerList.addListener(this);
                        DirectoryTableEvent.notifyRequestFileSelected(this);
                        if (this.m_selectedFile == null) break block5;
                        String fileName = this.m_selectedFile.getName();
                        int index = fileName.lastIndexOf(46);
                        if (index >= 0) {
                            fileName = fileName.substring(0, index);
                        }
                        String path = Preferences.getPreferences().getAnalysisResultsPath();
                        File lastSavedDirectory = new File(path);
                        File selectedFile = new File(path + File.separator + fileName + ".html");
                        JFileChooser fileChooser = new JFileChooser(lastSavedDirectory);
                        fileChooser.addChoosableFileFilter(new HTMLFileFilter());
                        fileChooser.setSelectedFile(selectedFile);
                        int result = fileChooser.showSaveDialog(PMDViewer.getViewer());
                        if (result != 0) break block5;
                        new SaveSaveAs().perform(fileChooser.getSelectedFile());
                    }
                    catch (PMDException pmdException) {
                        String message = pmdException.getMessage();
                        Exception exception = pmdException.getReason();
                        MessageDialog.show(PMDViewer.getViewer(), message, exception);
                        Object var10_13 = null;
                        ListenerList.removeListener(this);
                        return;
                    }
                }
                Object var10_12 = null;
                ListenerList.removeListener(this);
                return;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                ListenerList.removeListener(this);
                throw throwable;
            }
        }

        public void requestSelectedFile(DirectoryTableEvent event) {
        }

        public void fileSelectionChanged(DirectoryTableEvent event) {
        }

        public void fileSelected(DirectoryTableEvent event) {
            this.m_selectedFile = event.getSelectedFile();
        }
    }

    private class SaveActionListener
    implements ActionListener,
    DirectoryTableEventListener {
        private File m_selectedFile;

        private SaveActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(ActionEvent event) {
            try {
                block5: {
                    try {
                        ListenerList.addListener(this);
                        DirectoryTableEvent.notifyRequestFileSelected(this);
                        if (this.m_selectedFile == null) break block5;
                        String fileName = this.m_selectedFile.getName();
                        int index = fileName.lastIndexOf(46);
                        if (index >= 0) {
                            fileName = fileName.substring(0, index);
                        }
                        String directory = Preferences.getPreferences().getAnalysisResultsPath();
                        String path = directory + File.separator + fileName + ".html";
                        File outputFile = new File(path);
                        new SaveSaveAs().perform(outputFile);
                    }
                    catch (PMDException pmdException) {
                        String message = pmdException.getMessage();
                        Exception exception = pmdException.getReason();
                        MessageDialog.show(PMDViewer.getViewer(), message, exception);
                        Object var8_11 = null;
                        ListenerList.removeListener(this);
                        return;
                    }
                }
                Object var8_10 = null;
                ListenerList.removeListener(this);
                return;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                ListenerList.removeListener(this);
                throw throwable;
            }
        }

        public void requestSelectedFile(DirectoryTableEvent event) {
        }

        public void fileSelectionChanged(DirectoryTableEvent event) {
        }

        public void fileSelected(DirectoryTableEvent event) {
            this.m_selectedFile = event.getSelectedFile();
        }
    }

    private class SaveSaveAs
    implements HTMLAnalysisResultsEventListener {
        private String m_htmlText;

        private SaveSaveAs() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void perform(File outputFile) {
            if (outputFile == null) return;
            try {
                try {
                    ListenerList.addListener(this);
                    HTMLAnalysisResultsEvent.notifyRequestHTMLText(this);
                    FileWriter writer = null;
                    if (outputFile.exists()) {
                        outputFile.delete();
                    }
                    try {
                        try {
                            writer = new FileWriter(outputFile);
                            writer.write(this.m_htmlText);
                            String message = "Saved Search results to file \"" + outputFile.getPath() + "\".";
                            MessageDialog.show(PMDViewer.getViewer(), message);
                        }
                        catch (IOException ioException) {
                            String message2 = "Could not save Search results to a file.";
                            PMDException pmdException = new PMDException(message2, ioException);
                            pmdException.fillInStackTrace();
                            throw pmdException;
                        }
                        Object var7_7 = null;
                        {
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        try {
                            writer.close();
                            throw throwable;
                        }
                        catch (IOException exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (IOException exception) {}
                    writer.close();
                    Object var10_15 = null;
                }
                catch (PMDException pmdException) {
                    String message = pmdException.getMessage();
                    Exception exception = pmdException.getReason();
                    MessageDialog.show(PMDViewer.getViewer(), message, exception);
                    Object var10_16 = null;
                    ListenerList.removeListener(this);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var10_17 = null;
                ListenerList.removeListener(this);
                throw throwable;
            }
            ListenerList.removeListener(this);
        }

        public void requestHTMLAnalysisResults(HTMLAnalysisResultsEvent event) {
        }

        public void returnedHTMLAnalysisResults(HTMLAnalysisResultsEvent event) {
            this.m_htmlText = event.getHTMLText();
        }
    }

    private class EditMenu
    extends JMenu {
        private EditMenu() {
            super("Edit");
            this.setMnemonic('E');
            Icon icon = UIManager.getIcon("copy");
            SearchViewer.this.m_copyHTMLResultsMenuItem = new JMenuItem("Copy Results Results as HTML", icon);
            SearchViewer.this.m_copyHTMLResultsMenuItem.addActionListener(new CopyHTMLResultsActionListener());
            SearchViewer.this.m_copyHTMLResultsMenuItem.setMnemonic('C');
            SearchViewer.this.m_copyHTMLResultsMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            SearchViewer.this.m_copyHTMLResultsMenuItem.setEnabled(false);
            SearchViewer.this.m_copyHTMLResultsMenuItem.setDisabledIcon(icon);
            this.add(SearchViewer.this.m_copyHTMLResultsMenuItem);
            icon = UIManager.getIcon("copy");
            SearchViewer.this.m_copyTextResultsMenuItem = new JMenuItem("Copy Results Results as Text", icon);
            SearchViewer.this.m_copyTextResultsMenuItem.addActionListener(new CopyTextResultsActionListener());
            SearchViewer.this.m_copyTextResultsMenuItem.setMnemonic('Y');
            SearchViewer.this.m_copyTextResultsMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
            SearchViewer.this.m_copyTextResultsMenuItem.setEnabled(false);
            SearchViewer.this.m_copyTextResultsMenuItem.setDisabledIcon(icon);
            this.add(SearchViewer.this.m_copyTextResultsMenuItem);
            this.addMouseListener(new EditMenuMouseListener());
        }
    }

    private class FileMenu
    extends JMenu {
        private FileMenu() {
            super("File");
            this.setMnemonic('F');
            Icon icon = UIManager.getIcon("save");
            SearchViewer.this.m_saveMenuItem = new JMenuItem("Save Search Results", icon);
            SearchViewer.this.m_saveMenuItem.addActionListener(new SaveActionListener());
            SearchViewer.this.m_saveMenuItem.setMnemonic('S');
            SearchViewer.this.m_saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
            SearchViewer.this.m_saveMenuItem.setDisabledIcon(icon);
            this.add(SearchViewer.this.m_saveMenuItem);
            icon = UIManager.getIcon("saveAs");
            SearchViewer.this.m_saveAsMenuItem = new JMenuItem("Save Search Results As...", icon);
            SearchViewer.this.m_saveAsMenuItem.addActionListener(new SaveAsActionListener());
            SearchViewer.this.m_saveAsMenuItem.setMnemonic('A');
            SearchViewer.this.m_saveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
            SearchViewer.this.m_saveAsMenuItem.setDisabledIcon(icon);
            this.add(SearchViewer.this.m_saveAsMenuItem);
            this.add(new JSeparator());
            icon = UIManager.getIcon("print");
            SearchViewer.this.m_printAnalysisMenuItem = new JMenuItem("Print Search Results...", icon);
            SearchViewer.this.m_printAnalysisMenuItem.addActionListener(new PrintAnalysisActionListener());
            SearchViewer.this.m_printAnalysisMenuItem.setMnemonic('P');
            SearchViewer.this.m_printAnalysisMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
            SearchViewer.this.m_printAnalysisMenuItem.setDisabledIcon(icon);
            this.add(SearchViewer.this.m_printAnalysisMenuItem);
            this.add(new JSeparator());
            JMenuItem menuItem = new JMenuItem("Exit...");
            menuItem.addActionListener(new ExitActionListener());
            menuItem.setMnemonic('X');
            this.add(menuItem);
            this.addMouseListener(new FileMenuMouseListener());
        }
    }

    private class EditMenuMouseListener
    extends MouseAdapter
    implements HTMLAnalysisResultsEventListener {
        String m_htmlText;

        private EditMenuMouseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseEntered(MouseEvent event) {
            try {
                ListenerList.addListener(this);
                HTMLAnalysisResultsEvent.notifyRequestHTMLText(this);
                boolean enable = this.m_htmlText.length() > 0;
                SearchViewer.this.m_copyHTMLResultsMenuItem.setEnabled(enable);
                SearchViewer.this.m_copyTextResultsMenuItem.setEnabled(enable);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ListenerList.removeListener(this);
                throw throwable;
            }
            ListenerList.removeListener(this);
        }

        public void requestHTMLAnalysisResults(HTMLAnalysisResultsEvent event) {
        }

        public void returnedHTMLAnalysisResults(HTMLAnalysisResultsEvent event) {
            this.m_htmlText = event.getHTMLText();
        }
    }

    private class FileMenuMouseListener
    extends MouseAdapter
    implements HTMLAnalysisResultsEventListener {
        private String m_htmlText;

        private FileMenuMouseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseEntered(MouseEvent event) {
            try {
                ListenerList.addListener(this);
                HTMLAnalysisResultsEvent.notifyRequestHTMLText(this);
                boolean enable = this.m_htmlText.length() > 0;
                SearchViewer.this.m_saveMenuItem.setEnabled(enable);
                SearchViewer.this.m_saveAsMenuItem.setEnabled(enable);
                SearchViewer.this.m_printAnalysisMenuItem.setEnabled(enable);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ListenerList.removeListener(this);
                throw throwable;
            }
            ListenerList.removeListener(this);
        }

        public void requestHTMLAnalysisResults(HTMLAnalysisResultsEvent event) {
        }

        public void returnedHTMLAnalysisResults(HTMLAnalysisResultsEvent event) {
            this.m_htmlText = event.getHTMLText();
        }
    }

    private class CopyTextResultsActionListener
    implements ActionListener,
    TextAnalysisResultsEventListener {
        private String m_text;

        private CopyTextResultsActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent event) {
            try {
                ListenerList.addListener(this);
                TextAnalysisResultsEvent.notifyRequestText(this);
                if (this.m_text != null && this.m_text.length() > 0) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection contents = new StringSelection(this.m_text);
                    clipboard.setContents(contents, SearchViewer.this.m_clipboardOwner);
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                ListenerList.removeListener(this);
                throw throwable;
            }
            ListenerList.removeListener(this);
        }

        public void requestTextAnalysisResults(TextAnalysisResultsEvent event) {
        }

        public void returnedTextAnalysisResults(TextAnalysisResultsEvent event) {
            this.m_text = event.getText();
        }
    }

    private class CopyHTMLResultsActionListener
    implements ActionListener,
    HTMLAnalysisResultsEventListener {
        private String m_htmlText;

        private CopyHTMLResultsActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent event) {
            try {
                ListenerList.addListener(this);
                HTMLAnalysisResultsEvent.notifyRequestHTMLText(this);
                if (this.m_htmlText != null && this.m_htmlText.length() > 0) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection contents = new StringSelection(this.m_htmlText);
                    clipboard.setContents(contents, SearchViewer.this.m_clipboardOwner);
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                ListenerList.removeListener(this);
                throw throwable;
            }
            ListenerList.removeListener(this);
        }

        public void requestHTMLAnalysisResults(HTMLAnalysisResultsEvent event) {
        }

        public void returnedHTMLAnalysisResults(HTMLAnalysisResultsEvent event) {
            this.m_htmlText = event.getHTMLText();
        }
    }

    private class ExitActionListener
    implements ActionListener {
        private ExitActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            System.exit(0);
        }
    }

    private class PrintAnalysisActionListener
    implements ActionListener {
        private PrintAnalysisActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            new PrintAnalysisResults().print();
        }
    }
}

