/*
 * Decompiled with CFR 0.152.
 */
package org.cyberneko.relaxng;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Locale;
import org.apache.xerces.impl.XMLDTDScannerImpl;
import org.apache.xerces.impl.XMLDocumentScannerImpl;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.XMLNamespaceBinder;
import org.apache.xerces.parsers.BasicParserConfiguration;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XMLDTDContentModelHandler;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.relaxng.JingValidator;
import org.cyberneko.relaxng.ObjectFactory;
import org.cyberneko.relaxng.util.ContentHandler2XMLDocumentHandler;
import org.cyberneko.relaxng.util.XMLDTDHandler2DTDHandler;
import org.cyberneko.relaxng.util.XMLDTDHandlerTee;
import org.cyberneko.relaxng.util.XMLDocumentHandler2ContentHandler;

public class JingConfiguration
extends BasicParserConfiguration {
    protected static final String LOCALE = "http://apache.org/xml/properties/locale";
    protected static boolean XERCES_2_0_0 = false;
    protected static boolean XERCES_2_0_1 = false;
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLErrorHandler fErrorHandler;
    protected XMLEntityResolver fEntityResolver;
    protected SymbolTable fSymbolTable = new SymbolTable();
    protected XMLDocumentScannerImpl fDocumentScanner = new XMLDocumentScannerImpl();
    protected XMLDTDScannerImpl fDTDScanner = new XMLDTDScannerImpl();
    protected XMLDTDHandlerTee fDTDHandlerTee = new XMLDTDHandlerTee();
    protected XMLNamespaceBinder fNamespaceBinder = new XMLNamespaceBinder();
    protected JingValidator fJingValidator = new JingValidator();
    protected XMLEntityManager fEntityManager = new XMLEntityManager();
    protected XMLErrorReporter fErrorReporter = new XMLErrorReporter();
    protected XMLDocumentHandler2ContentHandler fDH2CH = new XMLDocumentHandler2ContentHandler();
    protected ContentHandler2XMLDocumentHandler fCH2DH = new ContentHandler2XMLDocumentHandler();
    protected XMLDTDHandler2DTDHandler fDTDXNI2SAX = new XMLDTDHandler2DTDHandler();

    public JingConfiguration() {
        Object[] objectArray;
        String[] stringArray = new String[]{"http://xml.org/sax/features/namespaces", "http://xml.org/sax/features/namespace-prefixes", "http://xml.org/sax/features/validation"};
        Boolean[] booleanArray = new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.FALSE};
        this.addRecognizedFeatures(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray = booleanArray[i];
            if (objectArray == null) continue;
            String string = stringArray[i];
            this.setFeature(string, objectArray.booleanValue());
        }
        String[] stringArray2 = new String[]{"http://apache.org/xml/properties/internal/document-scanner", "http://apache.org/xml/properties/internal/dtd-scanner", "http://apache.org/xml/properties/internal/namespace-binder", "http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/entity-manager", "http://apache.org/xml/properties/internal/error-reporter", LOCALE};
        objectArray = new Object[]{this.fDocumentScanner, this.fDTDScanner, this.fNamespaceBinder, this.fSymbolTable, this.fEntityManager, this.fErrorReporter, Locale.getDefault()};
        this.addRecognizedProperties(stringArray2);
        for (int i = 0; i < stringArray2.length; ++i) {
            Object object = objectArray[i];
            if (object == null) continue;
            String string = stringArray2[i];
            this.setProperty(string, object);
        }
        if (XERCES_2_0_0 || XERCES_2_0_1) {
            String[] stringArray3 = new String[]{"http://apache.org/xml/features/validation/schema/normalized-value"};
            this.addRecognizedFeatures(stringArray3);
        }
        XMLComponent[] xMLComponentArray = new XMLComponent[]{this.fDocumentScanner, this.fDTDScanner, this.fNamespaceBinder, this.fJingValidator, this.fEntityManager, this.fErrorReporter, this.fCH2DH};
        for (int i = 0; i < xMLComponentArray.length; ++i) {
            this.addComponent(xMLComponentArray[i]);
        }
    }

    public void setErrorHandler(XMLErrorHandler xMLErrorHandler) {
        this.fErrorHandler = xMLErrorHandler;
    }

    public XMLErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    public void setEntityResolver(XMLEntityResolver xMLEntityResolver) {
        this.fEntityResolver = xMLEntityResolver;
    }

    public XMLEntityResolver getEntityResolver() {
        return this.fEntityResolver;
    }

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void setDTDHandler(XMLDTDHandler xMLDTDHandler) {
    }

    public XMLDTDHandler getDTDHandler() {
        return null;
    }

    public void setDTDContentModelHandler(XMLDTDContentModelHandler xMLDTDContentModelHandler) {
    }

    public XMLDTDContentModelHandler getDTDContentModelHandler() {
        return null;
    }

    public void setLocale(Locale locale) {
        try {
            this.setProperty(LOCALE, locale);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Locale getLocale() {
        Locale locale = null;
        try {
            locale = (Locale)this.getProperty(LOCALE);
            this.fErrorReporter.setLocale(locale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return locale;
    }

    public void parse(XMLInputSource xMLInputSource) throws XNIException, IOException {
        this.reset();
        this.fDocumentScanner.setInputSource(xMLInputSource);
        this.fDocumentScanner.scanDocument(true);
    }

    protected void reset() throws XMLConfigurationException {
        super.reset();
        this.fErrorReporter.setDocumentLocator((XMLLocator)this.fEntityManager.getEntityScanner());
        this.configurePipeline();
    }

    protected void configurePipeline() {
        this.fDocumentScanner.setDocumentHandler((XMLDocumentHandler)this.fNamespaceBinder);
        this.fNamespaceBinder.setDocumentHandler((XMLDocumentHandler)this.fDH2CH);
        this.fDH2CH.setContentHandler(this.fJingValidator);
        this.fJingValidator.setContentHandler(this.fCH2DH);
        this.fCH2DH.setDocumentHandler(this.fDocumentHandler);
        this.fDTDScanner.setDTDHandler((XMLDTDHandler)this.fDTDHandlerTee);
        this.fDTDHandlerTee.setDTDHandler(this.fDTDXNI2SAX);
        this.fDTDXNI2SAX.setDTDHandler(this.fJingValidator);
        this.fDTDHandlerTee.setDTDHandler2(this.fDTDHandler);
        this.fDTDScanner.setDTDContentModelHandler(this.fDTDContentModelHandler);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("usage: java org.cyberneko.relaxng.JingConfiguration grammar file ...");
            System.exit(1);
        }
        SAXParser sAXParser = new SAXParser((XMLParserConfiguration)new JingConfiguration());
        sAXParser.setFeature("http://xml.org/sax/features/namespaces", true);
        sAXParser.setFeature("http://xml.org/sax/features/validation", true);
        sAXParser.setProperty("http://cyberneko.org/xml/properties/relaxng/schema-location", (Object)stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            String string = stringArray[i];
            System.err.println("# argv[" + i + "]: " + string);
            try {
                sAXParser.parse(string);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    static {
        try {
            String string = "org.apache.xerces.impl.Version";
            Object object = ObjectFactory.createObject(string, string);
            Field field = object.getClass().getField("fVersion");
            String string2 = String.valueOf(field.get(object));
            XERCES_2_0_0 = string2.equals("Xerces-J 2.0.0");
            XERCES_2_0_1 = string2.equals("Xerces-J 2.0.1");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

