/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4;

import org.jaudiotagger.tag.Tagger;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Mp4FieldKey {
    ARTIST("\u00a9ART", Mp4FieldType.TEXT),
    ALBUM("\u00a9alb", Mp4FieldType.TEXT),
    ALBUM_ARTIST("aART", Mp4FieldType.TEXT),
    GENRE_CUSTOM("\u00a9gen", Mp4FieldType.TEXT),
    GENRE("gnre", Mp4FieldType.NUMERIC),
    TITLE("\u00a9nam", Mp4FieldType.TEXT),
    TRACK("trkn", Mp4FieldType.NUMERIC),
    BPM("tmpo", Mp4FieldType.BYTE, 2),
    DAY("\u00a9day", Mp4FieldType.TEXT),
    COMMENT("\u00a9cmt", Mp4FieldType.TEXT),
    COMPOSER("\u00a9wrt", Mp4FieldType.TEXT),
    GROUPING("\u00a9grp", Mp4FieldType.TEXT),
    DISCNUMBER("disk", Mp4FieldType.NUMERIC),
    LYRICS("\u00a9lyr", Mp4FieldType.TEXT),
    RATING("rtng", Mp4FieldType.BYTE),
    ENCODER("\u00a9too", Mp4FieldType.TEXT),
    COMPILATION("cpil", Mp4FieldType.BYTE, 1),
    COPYRIGHT("cprt", Mp4FieldType.TEXT),
    CATEGORY("catg", Mp4FieldType.TEXT),
    KEYWORD("keyw", Mp4FieldType.TEXT),
    DESCRIPTION("desc", Mp4FieldType.TEXT),
    ARTIST_SORT("soar", Mp4FieldType.TEXT),
    ALBUM_ARTIST_SORT("soaa", Mp4FieldType.TEXT),
    ALBUM_SORT("soal", Mp4FieldType.TEXT),
    TITLE_SORT("sonm", Mp4FieldType.TEXT),
    COMPOSER_SORT("soco", Mp4FieldType.TEXT),
    SHOW_SORT("sosn", Mp4FieldType.TEXT),
    SHOW("tvsh", Mp4FieldType.TEXT),
    ARTWORK("covr", Mp4FieldType.COVERART_JPEG),
    PURCHASE_DATE("purd", Mp4FieldType.TEXT),
    MUSICBRAINZ_ARTISTID("com.apple.iTunes", "MusicBrainz Artist Id", Mp4FieldType.TEXT, Tagger.PICARD),
    MUSICBRAINZ_ALBUMID("com.apple.iTunes", "MusicBrainz Album Id", Mp4FieldType.TEXT, Tagger.PICARD),
    MUSICBRAINZ_ALBUMARTISTID("com.apple.iTunes", "MusicBrainz Album Artist Id", Mp4FieldType.TEXT, Tagger.PICARD),
    MUSICBRAINZ_TRACKID("com.apple.iTunes", "MusicBrainz Track Id", Mp4FieldType.TEXT, Tagger.PICARD),
    MUSICBRAINZ_DISCID("com.apple.iTunes", "MusicBrainz Disc Id", Mp4FieldType.TEXT, Tagger.PICARD),
    MUSICIP_PUID("com.apple.iTunes", "MusicIP PUID", Mp4FieldType.TEXT, Tagger.PICARD),
    ASIN("com.apple.iTunes", "ASIN", Mp4FieldType.TEXT, Tagger.PICARD),
    MUSICBRAINZ_ALBUM_STATUS("com.apple.iTunes", "MusicBrainz Album Status", Mp4FieldType.TEXT, Tagger.PICARD),
    MUSICBRAINZ_ALBUM_TYPE("com.apple.iTunes", "MusicBrainz Album Type", Mp4FieldType.TEXT, Tagger.PICARD),
    RELEASECOUNTRY("com.apple.iTunes", "MusicBrainz Album Release Country", Mp4FieldType.TEXT, Tagger.PICARD),
    PART_OF_GAPLESS_ALBUM("pgap", Mp4FieldType.BYTE),
    ITUNES_SMPB("com.apple.iTunes", "iTunSMPB", Mp4FieldType.TEXT),
    ITUNES_NORM("com.apple.iTunes", "iTunNORM", Mp4FieldType.TEXT),
    CONTENT_TYPE("stik", Mp4FieldType.BYTE, 1),
    PODCAST_KEYWORD("keyw", Mp4FieldType.TEXT),
    PODCAST_URL("purl", Mp4FieldType.NUMERIC),
    EPISODE_GLOBAL_ID("egid", Mp4FieldType.NUMERIC),
    TV_NETWORK("tvnn", Mp4FieldType.TEXT),
    TV_EPISODE_NUMBER("tven", Mp4FieldType.TEXT),
    TV_SEASON("tvsn", Mp4FieldType.BYTE, 1),
    TV_EPISODE("tves", Mp4FieldType.BYTE, 1),
    AP_ID("apID", Mp4FieldType.TEXT),
    AT_ID("atID", Mp4FieldType.BYTE, 4),
    CN_ID("cnID", Mp4FieldType.BYTE, 4),
    PL_ID("plID", Mp4FieldType.BYTE, 8),
    GE_ID("geID", Mp4FieldType.BYTE, 4),
    SF_ID("sfID", Mp4FieldType.BYTE, 4),
    AK_ID("akID", Mp4FieldType.BYTE, 1),
    SCORE("rate", Mp4FieldType.TEXT, Tagger.MEDIA_MONKEY),
    ISRC("isrc", Mp4FieldType.TEXT, Tagger.MEDIA_MONKEY),
    LYRICIST("lyrc", Mp4FieldType.TEXT, Tagger.MEDIA_MONKEY),
    CONDUCTOR("cond", Mp4FieldType.TEXT, Tagger.MEDIA_MONKEY),
    ORIGINAL_ARTIST("oart", Mp4FieldType.TEXT, Tagger.MEDIA_MONKEY),
    ORIGINAL_ALBUM_TITLE("otit", Mp4FieldType.TEXT, Tagger.MEDIA_MONKEY),
    ORIGINAL_LYRICIST("olyr", Mp4FieldType.TEXT, Tagger.MEDIA_MONKEY),
    INVOLVED_PEOPLE("peop", Mp4FieldType.TEXT, Tagger.MEDIA_MONKEY),
    TEMPO("empo", Mp4FieldType.TEXT, Tagger.MEDIA_MONKEY),
    MOOD("mood", Mp4FieldType.TEXT, Tagger.MEDIA_MONKEY),
    OCCASION("occa", Mp4FieldType.TEXT, Tagger.MEDIA_MONKEY),
    QUALITY("qual", Mp4FieldType.TEXT, Tagger.MEDIA_MONKEY),
    CUSTOM_1("cus1", Mp4FieldType.TEXT, Tagger.MEDIA_MONKEY),
    CUSTOM_2("cus2", Mp4FieldType.TEXT, Tagger.MEDIA_MONKEY),
    CUSTOM_3("cus3", Mp4FieldType.TEXT, Tagger.MEDIA_MONKEY),
    CUSTOM_4("cus4", Mp4FieldType.TEXT, Tagger.MEDIA_MONKEY),
    CUSTOM_5("cus5", Mp4FieldType.TEXT, Tagger.MEDIA_MONKEY);

    private Tagger tagger;
    private String fieldName;
    private String issuer;
    private String identifier;
    private Mp4FieldType fieldType;
    private int fieldLength;

    private Mp4FieldKey(String fieldName, Mp4FieldType fieldType) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
    }

    private Mp4FieldKey(String fieldName, Mp4FieldType fieldType, Tagger tagger) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.tagger = tagger;
    }

    private Mp4FieldKey(String fieldName, Mp4FieldType fieldType, int fieldLength) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.fieldLength = fieldLength;
    }

    private Mp4FieldKey(String issuer, String identifier, Mp4FieldType fieldType) {
        this.issuer = issuer;
        this.identifier = identifier;
        this.fieldName = "----:" + issuer + ":" + identifier;
        this.fieldType = fieldType;
    }

    private Mp4FieldKey(String issuer, String identifier, Mp4FieldType fieldType, Tagger tagger) {
        this.issuer = issuer;
        this.identifier = identifier;
        this.fieldName = "----:" + issuer + ":" + identifier;
        this.fieldType = fieldType;
        this.tagger = tagger;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Mp4FieldType getFieldType() {
        return this.fieldType;
    }

    public boolean isReverseDnsType() {
        return this.identifier.startsWith("----");
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getFieldLength() {
        return this.fieldLength;
    }

    public Tagger getTagger() {
        if (this.tagger != null) {
            return this.tagger;
        }
        return Tagger.ITUNES;
    }
}

