/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4.field;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.mp4.Mp4TagField;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;

public class Mp4TagRawBinaryField
extends Mp4TagField {
    protected int dataSize;
    protected byte[] dataBytes;

    public Mp4TagRawBinaryField(Mp4BoxHeader header, ByteBuffer raw) throws UnsupportedEncodingException {
        super(header.getId());
        this.dataSize = header.getDataLength();
        this.build(raw);
    }

    public Mp4FieldType getFieldType() {
        return Mp4FieldType.NUMERIC;
    }

    protected byte[] getDataBytes() throws UnsupportedEncodingException {
        return this.dataBytes;
    }

    protected void build(ByteBuffer raw) {
        this.dataBytes = new byte[this.dataSize];
        int i = 0;
        while (i < this.dataBytes.length) {
            this.dataBytes[i] = raw.get();
            ++i;
        }
    }

    public boolean isBinary() {
        return true;
    }

    public boolean isEmpty() {
        return this.dataBytes.length == 0;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public byte[] getData() {
        return this.dataBytes;
    }

    public void setData(byte[] d) {
        this.dataBytes = d;
    }

    public void copyContent(TagField field) {
        throw new UnsupportedOperationException("not done");
    }

    public byte[] getRawContent() throws UnsupportedEncodingException {
        try {
            ByteArrayOutputStream outerbaos = new ByteArrayOutputStream();
            outerbaos.write(Utils.getSizeBigEndian(8 + this.dataSize));
            outerbaos.write(Utils.getDefaultBytes(this.getId(), "ISO-8859-1"));
            outerbaos.write(this.dataBytes);
            return outerbaos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

