/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.util;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.jaudiotagger.audio.asf.util.Utils;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;

public final class AsfCopyrightField
implements TagTextField {
    public static final String FIELD_ID = "SPECIAL/WM/COPYRIGHT";
    private String value = "";

    public static TagTextField getCopyright(Tag tag) {
        TagField field;
        TagTextField result = null;
        List<TagField> list = tag.get(FIELD_ID);
        if (list != null && list.size() > 0 && (field = list.get(0)) instanceof TagTextField) {
            result = (TagTextField)field;
        }
        return result;
    }

    public void copyContent(TagField field) {
        if (field instanceof TagTextField) {
            this.value = ((TagTextField)field).getContent();
        }
    }

    public String getContent() {
        return this.value;
    }

    public String getEncoding() {
        return "UTF-16LE";
    }

    public String getId() {
        return FIELD_ID;
    }

    public byte[] getRawContent() throws UnsupportedEncodingException {
        return this.value.getBytes("UTF-16LE");
    }

    public boolean isBinary() {
        return false;
    }

    public void isBinary(boolean b) {
        if (b) {
            throw new UnsupportedOperationException("No conversion supported. Copyright is a String");
        }
    }

    public boolean isCommon() {
        return true;
    }

    public boolean isEmpty() {
        return this.value.length() == 0;
    }

    public void setContent(String s) {
        try {
            this.setString(s);
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            this.value = "Conversion Exception occured.";
        }
    }

    public void setEncoding(String s) {
        if (s == null || !s.equalsIgnoreCase("UTF-16LE")) {
            throw new UnsupportedOperationException("The encoding of Asf tags cannot be changed.(specified to be UTF-16LE)");
        }
    }

    public void setString(String s) {
        this.value = s;
        Utils.checkStringLengthNullSafe(this.value);
    }

    public String toString() {
        return "SPECIAL/WM/COPYRIGHT:\"" + this.getContent() + "\"";
    }
}

