/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.id3.AbstractTagFrame;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3v23Frame;
import org.jaudiotagger.tag.id3.ID3v24Frame;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUnsupported;

public abstract class AbstractID3v2Frame
extends AbstractTagFrame
implements TagField {
    protected static final String TYPE_FRAME = "frame";
    protected static final String TYPE_FRAME_SIZE = "frameSize";
    protected static final String UNSUPPORTED_ID = "Unsupported";
    protected String identifier = "";
    protected int frameSize;
    private String loggingFilename = "";
    StatusFlags statusFlags = null;
    EncodingFlags encodingFlags = null;

    protected AbstractID3v2Frame() {
    }

    public AbstractID3v2Frame(AbstractID3v2Frame frame) {
        super(frame);
    }

    public AbstractID3v2Frame(AbstractID3v2FrameBody body) {
        this.frameBody = body;
        this.frameBody.setHeader(this);
    }

    public AbstractID3v2Frame(String identifier) {
        this.identifier = identifier;
        try {
            Class<?> c = Class.forName("org.jaudiotagger.tag.id3.framebody.FrameBody" + identifier);
            this.frameBody = (AbstractID3v2FrameBody)c.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            this.frameBody = new FrameBodyUnsupported(identifier);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        this.frameBody.setHeader(this);
        if (this instanceof ID3v24Frame) {
            this.frameBody.setTextEncoding(TagOptionSingleton.getInstance().getId3v24DefaultTextEncoding());
        } else if (this instanceof ID3v23Frame) {
            this.frameBody.setTextEncoding(TagOptionSingleton.getInstance().getId3v23DefaultTextEncoding());
        }
    }

    protected String getLoggingFilename() {
        return this.loggingFilename;
    }

    protected void setLoggingFilename(String loggingFilename) {
        this.loggingFilename = loggingFilename;
    }

    public String getId() {
        return this.getIdentifier();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void copyContent(TagField field) {
    }

    protected AbstractID3v2FrameBody readBody(String identifier, ByteBuffer byteBuffer, int frameSize) throws InvalidFrameException {
        AbstractID3v2FrameBody frameBody;
        try {
            Class<?> c = Class.forName("org.jaudiotagger.tag.id3.framebody.FrameBody" + identifier);
            Class[] constructorParameterTypes = new Class[]{Class.forName("java.nio.ByteBuffer"), Integer.TYPE};
            Object[] constructorParameterValues = new Object[]{byteBuffer, frameSize};
            Constructor<?> construct = c.getConstructor(constructorParameterTypes);
            frameBody = (AbstractID3v2FrameBody)construct.newInstance(constructorParameterValues);
        }
        catch (ClassNotFoundException cex) {
            try {
                frameBody = new FrameBodyUnsupported(byteBuffer, frameSize);
            }
            catch (InvalidFrameException ife) {
                throw ife;
            }
            catch (InvalidTagException te) {
                throw new InvalidFrameException(te.getMessage());
            }
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() instanceof Error) {
                throw (Error)ite.getCause();
            }
            if (ite.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ite.getCause();
            }
            throw new InvalidFrameException(ite.getCause().getMessage());
        }
        catch (NoSuchMethodException sme) {
            throw new RuntimeException(sme.getMessage());
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae.getMessage());
        }
        frameBody.setHeader(this);
        return frameBody;
    }

    protected AbstractID3v2FrameBody readBody(String identifier, AbstractID3v2FrameBody body) throws InvalidFrameException {
        AbstractID3v2FrameBody frameBody;
        try {
            Class<?> c = Class.forName("org.jaudiotagger.tag.id3.framebody.FrameBody" + identifier);
            Class[] constructorParameterTypes = new Class[]{body.getClass()};
            Object[] constructorParameterValues = new Object[]{body};
            Constructor<?> construct = c.getConstructor(constructorParameterTypes);
            frameBody = (AbstractID3v2FrameBody)construct.newInstance(constructorParameterValues);
        }
        catch (ClassNotFoundException cex) {
            throw new InvalidFrameException("FrameBody" + identifier + " does not exist");
        }
        catch (NoSuchMethodException sme) {
            throw new InvalidFrameException("FrameBody" + identifier + " does not have a constructor that takes:" + body.getClass().getName());
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() instanceof Error) {
                throw (Error)ite.getCause();
            }
            if (ite.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ite.getCause();
            }
            throw new InvalidFrameException(ite.getCause().getMessage());
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae.getMessage());
        }
        frameBody.setHeader(this);
        return frameBody;
    }

    public byte[] getRawContent() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.write(baos);
        return baos.toByteArray();
    }

    public abstract void write(ByteArrayOutputStream var1);

    public void isBinary(boolean b) {
    }

    public boolean isEmpty() {
        AbstractTagFrameBody body = this.getBody();
        return body == null;
    }

    protected StatusFlags getStatusFlags() {
        return this.statusFlags;
    }

    protected EncodingFlags getEncodingFlags() {
        return this.encodingFlags;
    }

    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement(TYPE_FRAME, this.getIdentifier());
        MP3File.getStructureFormatter().closeHeadingElement(TYPE_FRAME);
    }

    class EncodingFlags {
        protected static final String TYPE_FLAGS = "encodingFlags";
        protected byte flags;

        protected EncodingFlags() {
            this.resetFlags();
        }

        protected EncodingFlags(byte flags) {
            this.setFlags(flags);
        }

        public byte getFlags() {
            return this.flags;
        }

        public void setFlags(byte flags) {
            this.flags = flags;
        }

        public void resetFlags() {
            this.setFlags((byte)0);
        }

        public void createStructure() {
        }
    }

    class StatusFlags {
        protected static final String TYPE_FLAGS = "statusFlags";
        protected byte originalFlags;
        protected byte writeFlags;

        protected StatusFlags() {
        }

        public byte getOriginalFlags() {
            return this.originalFlags;
        }

        public byte getWriteFlags() {
            return this.writeFlags;
        }

        public void createStructure() {
        }
    }
}

