/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.EmptyFrameException;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.InvalidFrameIdentifierException;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.ID3Tags;
import org.jaudiotagger.tag.id3.ID3v22Frame;
import org.jaudiotagger.tag.id3.ID3v23Frames;
import org.jaudiotagger.tag.id3.ID3v24Frame;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyDeprecated;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUnsupported;
import org.jaudiotagger.tag.id3.framebody.ID3v23FrameBody;

public class ID3v23Frame
extends AbstractID3v2Frame {
    Pattern validFrameIdentifier = Pattern.compile("[A-Z][0-9A-Z]{3}");
    protected static final int FRAME_ID_SIZE = 4;
    protected static final int FRAME_FLAGS_SIZE = 2;
    protected static final int FRAME_SIZE_SIZE = 4;
    protected static final int FRAME_COMPRESSION_UNCOMPRESSED_SIZE = 4;
    protected static final int FRAME_ENCRYPTION_INDICATOR_SIZE = 1;
    protected static final int FRAME_GROUPING_INDICATOR_SIZE = 1;
    protected static final int FRAME_HEADER_SIZE = 10;

    public ID3v23Frame() {
    }

    public ID3v23Frame(String identifier) {
        super(identifier);
        this.statusFlags = new StatusFlags();
        this.encodingFlags = new EncodingFlags();
    }

    public ID3v23Frame(ID3v23Frame frame) {
        super(frame);
        this.statusFlags = new StatusFlags(frame.getStatusFlags().getOriginalFlags());
        this.encodingFlags = new EncodingFlags(frame.getEncodingFlags().getFlags());
    }

    /*
     * Enabled aggressive block sorting
     */
    public ID3v23Frame(AbstractID3v2Frame frame) throws InvalidFrameException {
        if (frame instanceof ID3v23Frame && !(frame instanceof ID3v24Frame)) {
            throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
        }
        if (frame instanceof ID3v24Frame) {
            this.statusFlags = new StatusFlags((ID3v24Frame.StatusFlags)frame.getStatusFlags());
            this.encodingFlags = new EncodingFlags(frame.getEncodingFlags().getFlags());
        }
        if (frame instanceof ID3v24Frame) {
            if (ID3Tags.isID3v24FrameIdentifier(frame.getIdentifier())) {
                this.identifier = ID3Tags.convertFrameID24To23(frame.getIdentifier());
                if (this.identifier != null) {
                    this.frameBody = (AbstractID3v2FrameBody)ID3Tags.copyObject(frame.getBody());
                    this.frameBody.setHeader(this);
                    return;
                }
                this.identifier = ID3Tags.forceFrameID24To23(frame.getIdentifier());
                if (this.identifier != null) {
                    this.frameBody = this.readBody(this.identifier, (AbstractID3v2FrameBody)frame.getBody());
                    this.frameBody.setHeader(this);
                    return;
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ((AbstractID3v2FrameBody)frame.getBody()).write(baos);
                this.identifier = frame.getIdentifier();
                this.frameBody = new FrameBodyUnsupported(this.identifier, baos.toByteArray());
                this.frameBody.setHeader(this);
                return;
            }
            if (frame.getBody() instanceof FrameBodyUnsupported) {
                this.frameBody = new FrameBodyUnsupported((FrameBodyUnsupported)frame.getBody());
                this.frameBody.setHeader(this);
                this.identifier = frame.getIdentifier();
                return;
            }
            if (!(frame.getBody() instanceof FrameBodyDeprecated)) throw new InvalidFrameException("Orig id is:" + frame.getIdentifier() + "Unable to create Frame Body");
            if (ID3Tags.isID3v23FrameIdentifier(frame.getIdentifier())) {
                this.frameBody = ((FrameBodyDeprecated)frame.getBody()).getOriginalFrameBody();
                this.frameBody.setHeader(this);
                this.identifier = frame.getIdentifier();
                return;
            }
            this.frameBody = new FrameBodyDeprecated((FrameBodyDeprecated)frame.getBody());
            this.frameBody.setHeader(this);
            this.identifier = frame.getIdentifier();
            return;
        }
        if (!(frame instanceof ID3v22Frame)) return;
        if (!ID3Tags.isID3v22FrameIdentifier(frame.getIdentifier())) {
            this.frameBody = new FrameBodyUnsupported((FrameBodyUnsupported)frame.getBody());
            this.frameBody.setHeader(this);
            this.identifier = frame.getIdentifier();
            return;
        }
        this.identifier = ID3Tags.convertFrameID22To23(frame.getIdentifier());
        if (this.identifier != null) {
            this.frameBody = (AbstractID3v2FrameBody)ID3Tags.copyObject(frame.getBody());
            this.frameBody.setHeader(this);
            return;
        }
        if (!ID3Tags.isID3v22FrameIdentifier(frame.getIdentifier())) return;
        this.identifier = ID3Tags.forceFrameID22To23(frame.getIdentifier());
        if (this.identifier != null) {
            this.frameBody = this.readBody(this.identifier, (AbstractID3v2FrameBody)frame.getBody());
            this.frameBody.setHeader(this);
            return;
        }
        this.frameBody = new FrameBodyDeprecated((AbstractID3v2FrameBody)frame.getBody());
        this.frameBody.setHeader(this);
        this.identifier = frame.getIdentifier();
    }

    public ID3v23Frame(ByteBuffer byteBuffer, String loggingFilename) throws InvalidFrameException {
        this.setLoggingFilename(loggingFilename);
        this.read(byteBuffer);
    }

    public ID3v23Frame(ByteBuffer byteBuffer) throws InvalidFrameException {
        this(byteBuffer, "");
    }

    public int getSize() {
        return this.frameBody.getSize() + 10;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v23Frame)) {
            return false;
        }
        ID3v23Frame object = (ID3v23Frame)obj;
        if (this.statusFlags.getOriginalFlags() != object.statusFlags.getOriginalFlags()) {
            return false;
        }
        if (this.encodingFlags.getFlags() != object.encodingFlags.getFlags()) {
            return false;
        }
        return super.equals(obj);
    }

    public void read(ByteBuffer byteBuffer) throws InvalidFrameException {
        if (byteBuffer.position() + 10 >= byteBuffer.limit()) {
            throw new InvalidFrameException(String.valueOf(this.getLoggingFilename()) + ":No space to find another frame");
        }
        byte[] buffer = new byte[4];
        byteBuffer.get(buffer, 0, 4);
        this.identifier = new String(buffer);
        if (!this.isValidID3v2FrameIdentifier(this.identifier)) {
            byteBuffer.position(byteBuffer.position() - 3);
            throw new InvalidFrameIdentifierException(String.valueOf(this.getLoggingFilename()) + ":" + this.identifier + "is not a valid ID3v2.30 frame");
        }
        this.frameSize = byteBuffer.getInt();
        if (this.frameSize < 0) {
            throw new InvalidFrameException(String.valueOf(this.identifier) + " is invalid frame");
        }
        if (this.frameSize == 0) {
            throw new EmptyFrameException(String.valueOf(this.identifier) + " is empty frame");
        }
        if (this.frameSize > byteBuffer.remaining()) {
            throw new InvalidFrameException(String.valueOf(this.identifier) + " is invalid frame");
        }
        this.statusFlags = new StatusFlags(byteBuffer.get());
        this.encodingFlags = new EncodingFlags(byteBuffer.get());
        String id = ID3Tags.convertFrameID23To24(this.identifier);
        if (id == null) {
            id = ID3Tags.isID3v23FrameIdentifier(this.identifier) ? this.identifier : "Unsupported";
        }
        int extraHeaderBytesCount = 0;
        int decompressedFrameSize = -1;
        if (((EncodingFlags)this.encodingFlags).isCompression()) {
            decompressedFrameSize = byteBuffer.getInt();
            extraHeaderBytesCount = 4;
        }
        if (((EncodingFlags)this.encodingFlags).isEncryption()) {
            ++extraHeaderBytesCount;
            byteBuffer.get();
        }
        if (((EncodingFlags)this.encodingFlags).isGrouping()) {
            ++extraHeaderBytesCount;
            byteBuffer.get();
        }
        int realFrameSize = this.frameSize - extraHeaderBytesCount;
        ByteBuffer frameBodyBuffer = null;
        if (((EncodingFlags)this.encodingFlags).isCompression()) {
            byte[] result = new byte[decompressedFrameSize];
            byte[] input = new byte[realFrameSize];
            int position = byteBuffer.position();
            byteBuffer.get(input, 0, realFrameSize);
            byteBuffer.position(position);
            Inflater decompresser = new Inflater();
            decompresser.setInput(input);
            try {
                decompresser.inflate(result);
            }
            catch (DataFormatException dfe) {
                dfe.printStackTrace();
                byteBuffer.position(byteBuffer.position() + realFrameSize);
                throw new InvalidFrameException(String.valueOf(this.getLoggingFilename()) + "Unable to decompress this frame:" + this.identifier + ":" + dfe.getMessage());
            }
            decompresser.end();
            frameBodyBuffer = ByteBuffer.wrap(result);
        }
        try {
            if (((EncodingFlags)this.encodingFlags).isCompression()) {
                this.frameBody = this.readBody(id, frameBodyBuffer, decompressedFrameSize);
            } else {
                frameBodyBuffer = byteBuffer.slice();
                frameBodyBuffer.limit(realFrameSize);
                this.frameBody = this.readBody(id, frameBodyBuffer, realFrameSize);
            }
            if (!(this.frameBody instanceof ID3v23FrameBody)) {
                this.frameBody = new FrameBodyDeprecated((AbstractID3v2FrameBody)this.frameBody);
            }
        }
        finally {
            byteBuffer.position(byteBuffer.position() + realFrameSize);
        }
    }

    public void write(ByteArrayOutputStream tagBuffer) {
        ByteBuffer headerBuffer = ByteBuffer.allocate(10);
        ByteArrayOutputStream bodyOutputStream = new ByteArrayOutputStream();
        ((AbstractID3v2FrameBody)this.frameBody).write(bodyOutputStream);
        if (this.getIdentifier().length() == 3) {
            this.identifier = String.valueOf(this.identifier) + ' ';
        }
        headerBuffer.put(Utils.getDefaultBytes(this.getIdentifier(), "ISO-8859-1"), 0, 4);
        int size = this.frameBody.getSize();
        headerBuffer.putInt(this.frameBody.getSize());
        headerBuffer.put(this.statusFlags.getWriteFlags());
        this.encodingFlags.resetFlags();
        headerBuffer.put(this.encodingFlags.getFlags());
        try {
            tagBuffer.write(headerBuffer.array());
            tagBuffer.write(bodyOutputStream.toByteArray());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected AbstractID3v2Frame.StatusFlags getStatusFlags() {
        return this.statusFlags;
    }

    protected AbstractID3v2Frame.EncodingFlags getEncodingFlags() {
        return this.encodingFlags;
    }

    public boolean isValidID3v2FrameIdentifier(String identifier) {
        Matcher m = this.validFrameIdentifier.matcher(identifier);
        return m.matches();
    }

    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("frame", this.getIdentifier());
        MP3File.getStructureFormatter().addElement("frameSize", this.frameSize);
        this.statusFlags.createStructure();
        this.encodingFlags.createStructure();
        this.frameBody.createStructure();
        MP3File.getStructureFormatter().closeHeadingElement("frame");
    }

    public boolean isCommon() {
        return ID3v23Frames.getInstanceOf().isCommon(this.getId());
    }

    public boolean isBinary() {
        return ID3v23Frames.getInstanceOf().isBinary(this.getId());
    }

    class EncodingFlags
    extends AbstractID3v2Frame.EncodingFlags {
        public static final String TYPE_COMPRESSION = "compression";
        public static final String TYPE_ENCRYPTION = "encryption";
        public static final String TYPE_GROUPIDENTITY = "groupidentity";
        public static final int MASK_COMPRESSION = 128;
        public static final int MASK_ENCRYPTION = 64;
        public static final int MASK_GROUPING_IDENTITY = 32;

        public EncodingFlags() {
            super(ID3v23Frame.this);
        }

        public EncodingFlags(byte flags) {
            super(ID3v23Frame.this, flags);
            this.logEnabledFlags();
        }

        public void logEnabledFlags() {
            this.isCompression();
            this.isEncryption();
            this.isGrouping();
        }

        public boolean isCompression() {
            return (this.flags & 0x80) > 0;
        }

        public boolean isEncryption() {
            return (this.flags & 0x40) > 0;
        }

        public boolean isGrouping() {
            return (this.flags & 0x20) > 0;
        }

        public void createStructure() {
            MP3File.getStructureFormatter().openHeadingElement("encodingFlags", "");
            MP3File.getStructureFormatter().addElement(TYPE_COMPRESSION, this.flags & 0x80);
            MP3File.getStructureFormatter().addElement(TYPE_ENCRYPTION, this.flags & 0x40);
            MP3File.getStructureFormatter().addElement(TYPE_GROUPIDENTITY, this.flags & 0x20);
            MP3File.getStructureFormatter().closeHeadingElement("encodingFlags");
        }
    }

    class StatusFlags
    extends AbstractID3v2Frame.StatusFlags {
        public static final String TYPE_TAGALTERPRESERVATION = "typeTagAlterPreservation";
        public static final String TYPE_FILEALTERPRESERVATION = "typeFileAlterPreservation";
        public static final String TYPE_READONLY = "typeReadOnly";
        public static final int MASK_TAG_ALTER_PRESERVATION = 128;
        public static final int MASK_FILE_ALTER_PRESERVATION = 64;
        public static final int MASK_READ_ONLY = 32;

        public StatusFlags() {
            super(ID3v23Frame.this);
            this.originalFlags = 0;
            this.writeFlags = 0;
        }

        StatusFlags(byte flags) {
            super(ID3v23Frame.this);
            this.originalFlags = flags;
            this.writeFlags = flags;
            this.modifyFlags();
        }

        StatusFlags(ID3v24Frame.StatusFlags statusFlags) {
            super(ID3v23Frame.this);
            this.writeFlags = this.originalFlags = this.convertV4ToV3Flags(statusFlags.getOriginalFlags());
            this.modifyFlags();
        }

        private byte convertV4ToV3Flags(byte v4Flag) {
            byte v3Flag = 0;
            if ((v4Flag & 0x20) != 0) {
                v3Flag = (byte)(v3Flag | 0x40);
            }
            if ((v4Flag & 0x40) != 0) {
                v3Flag = (byte)(v3Flag | 0xFFFFFF80);
            }
            return v3Flag;
        }

        protected void modifyFlags() {
            String str = ID3v23Frame.this.getIdentifier();
            if (ID3v23Frames.getInstanceOf().isDiscardIfFileAltered(str)) {
                this.writeFlags = (byte)(this.writeFlags | 0x40);
                this.writeFlags = (byte)(this.writeFlags & 0x7F);
            } else {
                this.writeFlags = (byte)(this.writeFlags & 0xFFFFFFBF);
                this.writeFlags = (byte)(this.writeFlags & 0x7F);
            }
        }

        public void createStructure() {
            MP3File.getStructureFormatter().openHeadingElement("statusFlags", "");
            MP3File.getStructureFormatter().addElement(TYPE_TAGALTERPRESERVATION, this.originalFlags & 0x80);
            MP3File.getStructureFormatter().addElement(TYPE_FILEALTERPRESERVATION, this.originalFlags & 0x40);
            MP3File.getStructureFormatter().addElement(TYPE_READONLY, this.originalFlags & 0x20);
            MP3File.getStructureFormatter().closeHeadingElement("statusFlags");
        }
    }
}

