/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.util.Iterator;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.StringUtil;

public class HTMLRenderer
implements Renderer {
    protected String EOL = System.getProperty("line.separator", "\n");

    public String render(Report report) {
        StringBuffer buf = new StringBuffer("<html><head><title>PMD</title></head><body>" + this.EOL + "<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>" + this.EOL + "<th>#</th><th>File</th><th>Line</th><th>Problem</th></tr>" + this.EOL);
        boolean colorize = true;
        int violationCount = 1;
        Iterator i = report.iterator();
        while (i.hasNext()) {
            RuleViolation rv = (RuleViolation)i.next();
            buf.append("<tr");
            if (colorize) {
                buf.append(" bgcolor=\"lightgrey\"");
                colorize = false;
            } else {
                colorize = true;
            }
            buf.append("> " + this.EOL);
            buf.append("<td align=\"center\">" + violationCount + "</td>" + this.EOL);
            buf.append("<td width=\"*%\">" + rv.getFilename() + "</td>" + this.EOL);
            buf.append("<td align=\"center\" width=\"5%\">" + Integer.toString(rv.getLine()) + "</td>" + this.EOL);
            String d = rv.getDescription();
            d = StringUtil.replaceString(d, '&', "&amp;");
            d = StringUtil.replaceString(d, '<', "&lt;");
            d = StringUtil.replaceString(d, '>', "&gt;");
            buf.append("<td width=\"*\">" + d + "</td>" + this.EOL);
            buf.append("</tr>" + this.EOL);
            ++violationCount;
        }
        buf.append("</table></body></html>");
        return buf.toString();
    }
}

