/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.awt.Component;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import net.sourceforge.pmd.swingui.DirectoryTreeModel;
import net.sourceforge.pmd.swingui.DirectoryTreeNode;
import net.sourceforge.pmd.swingui.event.ListenerList;
import net.sourceforge.pmd.swingui.event.SetupFilesEvent;
import net.sourceforge.pmd.swingui.event.SetupFilesEventListener;
import net.sourceforge.pmd.swingui.event.StatusBarEvent;

class DirectoryTree
extends JTree {
    protected DirectoryTree(String rootName) {
        super(new DirectoryTreeModel(rootName));
        this.setRootVisible(true);
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.setCellRenderer(new DirectoryTreeNodeRenderer());
        ((DirectoryTreeModel)this.getModel()).setDirectoryTree(this);
        this.setBackground(UIManager.getColor("pmdTreeBackground"));
        ListenerList.addListener(new SetupFilesEventHandler());
    }

    protected void expandRootNode() {
        DirectoryTreeModel treeModel = (DirectoryTreeModel)this.getModel();
        DirectoryTreeNode treeNode = (DirectoryTreeNode)treeModel.getRoot();
        TreePath treePath = new TreePath(treeNode.getPath());
        this.expandPath(treePath);
    }

    protected DirectoryTreeNode getSelectedNode() {
        TreePath path = this.getSelectionModel().getSelectionPath();
        return (DirectoryTreeNode)path.getLastPathComponent();
    }

    private class DirectoryTreeNodeRenderer
    extends DefaultTreeCellRenderer {
        private Icon m_defaultClosedIcon = this.getDefaultClosedIcon();
        private Icon m_defaultLeafIcon = this.getDefaultLeafIcon();
        private Icon m_defaultOpenIcon = this.getDefaultOpenIcon();

        protected DirectoryTreeNodeRenderer() {
            this.setBackgroundNonSelectionColor(UIManager.getColor("pmdTreeBackground"));
        }

        public Component getTreeCellRendererComponent(JTree tree, Object object, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
            DirectoryTreeNode treeNode = (DirectoryTreeNode)object;
            Object userObject = treeNode.getUserObject();
            if (userObject instanceof String) {
                this.setClosedIcon(this.m_defaultClosedIcon);
                this.setLeafIcon(this.m_defaultClosedIcon);
                this.setOpenIcon(this.m_defaultOpenIcon);
            } else if (((File)userObject).isFile()) {
                this.setClosedIcon(this.m_defaultClosedIcon);
                this.setLeafIcon(this.m_defaultLeafIcon);
                this.setOpenIcon(this.m_defaultOpenIcon);
            } else {
                this.setClosedIcon(this.m_defaultClosedIcon);
                this.setLeafIcon(this.m_defaultClosedIcon);
                this.setOpenIcon(this.m_defaultOpenIcon);
            }
            return super.getTreeCellRendererComponent(tree, object, isSelected, isExpanded, isLeaf, row, hasFocus);
        }
    }

    private class SetupFilesThread
    extends Thread {
        private File[] m_rootDirectories;

        private SetupFilesThread(String threadName, File[] rootDirectories) {
            super(threadName);
            this.m_rootDirectories = rootDirectories;
        }

        public void run() {
            this.setup();
            this.process();
            this.cleanup();
        }

        protected void setup() {
            SetupFilesEvent.notifyStartSetup(this);
            StatusBarEvent.notifyStartAnimation(this);
        }

        protected void process() {
            StatusBarEvent.notifyShowMessage(this, "Locating root directories.  Please wait...");
            DirectoryTreeModel treeModel = (DirectoryTreeModel)DirectoryTree.this.getModel();
            treeModel.setupFiles(this.m_rootDirectories);
            DirectoryTree.this.expandRootNode();
        }

        protected void cleanup() {
            StatusBarEvent.notifyStopAnimation(this);
            SetupFilesEvent.notifyStopSetup(this);
        }
    }

    private class SetupFilesEventHandler
    implements SetupFilesEventListener {
        private SetupFilesEventHandler() {
        }

        public void startSetup(SetupFilesEvent event) {
        }

        public void stopSetup(SetupFilesEvent event) {
        }

        public void setFileList(SetupFilesEvent event) {
            File[] directories = event.getFileList();
            String name = "Locating root directories.";
            SetupFilesThread setupFilesThread = new SetupFilesThread(name, directories);
            setupFilesThread.start();
        }
    }
}

