/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd;

import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.ReportListener;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.renderers.XMLRenderer;
import net.sourceforge.pmd.stat.Metric;
import test.net.sourceforge.pmd.MockRule;

public class ReportTest
extends TestCase
implements ReportListener {
    private boolean violationSemaphore;
    private boolean metricSemaphore;

    public void testBasic() {
        Report r = new Report();
        RuleContext ctx = new RuleContext();
        ctx.setSourceCodeFilename("foo");
        r.addRuleViolation(new RuleViolation(new MockRule("name", "desc", "msg"), 5, ctx));
        Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
    }

    public void testMetric0() {
        Report r = new Report();
        Assert.assertTrue((String)"Default report shouldn't contain metrics", (!r.hasMetrics() ? 1 : 0) != 0);
    }

    public void testMetric1() {
        Report r = new Report();
        Assert.assertTrue((String)"Default report shouldn't contain metrics", (!r.hasMetrics() ? 1 : 0) != 0);
        r.addMetric(new Metric("m1", 0, 0.0, 1.0, 2.0, 3.0, 4.0));
        Assert.assertTrue((String)"Expected metrics weren't there", (boolean)r.hasMetrics());
        Iterator ms = r.metrics();
        Assert.assertTrue((String)"Should have some metrics in there now", (boolean)ms.hasNext());
        Object o = ms.next();
        Assert.assertTrue((String)("Expected Metric, got " + o.getClass()), (boolean)(o instanceof Metric));
        Metric m = (Metric)o;
        Assert.assertEquals((String)"metric name mismatch", (String)"m1", (String)m.getMetricName());
        Assert.assertEquals((String)"wrong low value", (double)1.0, (double)m.getLowValue(), (double)0.05);
        Assert.assertEquals((String)"wrong high value", (double)2.0, (double)m.getHighValue(), (double)0.05);
        Assert.assertEquals((String)"wrong avg value", (double)3.0, (double)m.getAverage(), (double)0.05);
        Assert.assertEquals((String)"wrong std dev value", (double)4.0, (double)m.getStandardDeviation(), (double)0.05);
    }

    public void testSortedReport_File() {
        Report r = new Report();
        RuleContext ctx = new RuleContext();
        ctx.setSourceCodeFilename("foo");
        r.addRuleViolation(new RuleViolation(new MockRule("name", "desc", "msg"), 10, ctx));
        ctx.setSourceCodeFilename("bar");
        r.addRuleViolation(new RuleViolation(new MockRule("name", "desc", "msg"), 20, ctx));
        XMLRenderer rend = new XMLRenderer();
        String result = rend.render(r);
        Assert.assertTrue((String)"sort order wrong", (result.indexOf("bar") < result.indexOf("foo") ? 1 : 0) != 0);
    }

    public void testSortedReport_Line() {
        Report r = new Report();
        RuleContext ctx = new RuleContext();
        ctx.setSourceCodeFilename("foo1");
        r.addRuleViolation(new RuleViolation(new MockRule("rule2", "rule2", "msg"), 10, ctx));
        ctx.setSourceCodeFilename("foo2");
        r.addRuleViolation(new RuleViolation(new MockRule("rule1", "rule1", "msg"), 20, ctx));
        XMLRenderer rend = new XMLRenderer();
        String result = rend.render(r);
        Assert.assertTrue((String)"sort order wrong", (result.indexOf("rule2") < result.indexOf("rule1") ? 1 : 0) != 0);
    }

    public void testListener() {
        Report rpt = new Report();
        rpt.addListener(this);
        this.violationSemaphore = false;
        RuleContext ctx = new RuleContext();
        ctx.setSourceCodeFilename("file");
        rpt.addRuleViolation(new RuleViolation(new MockRule("name", "desc", "msg"), 5, ctx));
        Assert.assertTrue((boolean)this.violationSemaphore);
        this.metricSemaphore = false;
        rpt.addMetric(new Metric("test", 0, 0.0, 0.0, 0.0, 0.0, 0.0));
        Assert.assertTrue((String)"no metric", (boolean)this.metricSemaphore);
    }

    public void ruleViolationAdded(RuleViolation ruleViolation) {
        this.violationSemaphore = true;
    }

    public void metricAdded(Metric metric) {
        this.metricSemaphore = true;
    }
}

