/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.JavaParser;
import test.net.sourceforge.pmd.MockRule;

public class RuleSetTest
extends TestCase {
    private String javaCode = "public class Test { }";

    public void testConstructor() {
        new RuleSet();
    }

    public void testAccessors() {
        RuleSet rs = new RuleSet();
        rs.setName("foo");
        Assert.assertEquals((String)"name mismatch", (String)"foo", (String)rs.getName());
        rs.setDescription("bar");
        Assert.assertEquals((String)"description mismatch", (String)"bar", (String)rs.getDescription());
    }

    public void testGetRuleByName() {
        RuleSet rs = new RuleSet();
        MockRule mock = new MockRule("name", "desc", "msg");
        rs.addRule(mock);
        Assert.assertEquals((String)"unable to fetch rule by name", (Object)mock, (Object)rs.getRuleByName("name"));
    }

    public void testRuleList() {
        RuleSet IUT = new RuleSet();
        Assert.assertEquals((String)"Size of RuleSet isn't zero.", (int)0, (int)IUT.size());
        MockRule rule = new MockRule("name", "desc", "msg");
        IUT.addRule(rule);
        Assert.assertEquals((String)"Size of RuleSet isn't one.", (int)1, (int)IUT.size());
        Set rules = IUT.getRules();
        Iterator i = rules.iterator();
        Assert.assertTrue((String)"Empty Set", (boolean)i.hasNext());
        Assert.assertEquals((String)"Returned set of wrong size.", (int)1, (int)rules.size());
        Assert.assertEquals((String)"Rule isn't in ruleset.", (Object)rule, i.next());
    }

    public void testAddRuleSet() {
        RuleSet set1 = new RuleSet();
        set1.addRule(new MockRule("name", "desc", "msg"));
        RuleSet set2 = new RuleSet();
        set2.addRule(new MockRule("name", "desc", "msg"));
        set1.addRuleSet(set2);
        Assert.assertEquals((String)"ruleset size wrong", (int)2, (int)set1.size());
    }

    public void testApply0Rules() throws Throwable {
        RuleSet IUT = new RuleSet();
        this.verifyRuleSet(IUT, 0, new HashSet());
    }

    public void testApply1Rule() throws Throwable {
        RuleSet IUT = new RuleSet();
        MockRule rule = new MockRule("name", "desc", "msg");
        RuleContext ctx = new RuleContext();
        ctx.setSourceCodeFilename("filename");
        RuleViolation violation = new RuleViolation(rule, 1, ctx);
        rule.addViolation(violation);
        IUT.addRule(rule);
        this.verifyRuleSet(IUT, 1, Collections.singleton(violation));
    }

    public void testApplyNRule() throws Throwable {
        RuleSet IUT = new RuleSet();
        Random rand = new Random();
        int numRules = rand.nextInt(10) + 1;
        HashSet<RuleViolation> ruleViolations = new HashSet<RuleViolation>();
        int i = 0;
        while (i < numRules) {
            MockRule rule = new MockRule("name", "desc", "msg");
            RuleContext ctx = new RuleContext();
            ctx.setSourceCodeFilename("filename");
            RuleViolation violation = new RuleViolation(rule, i, ctx);
            ruleViolations.add(violation);
            rule.addViolation(violation);
            IUT.addRule(rule);
            ++i;
        }
        this.verifyRuleSet(IUT, numRules, ruleViolations);
    }

    protected void verifyRuleSet(RuleSet IUT, int size, Set values) throws Throwable {
        RuleContext context = new RuleContext();
        HashSet<RuleViolation> reportedValues = new HashSet<RuleViolation>();
        context.setReport(new Report());
        IUT.apply(this.makeCompilationUnits(), context);
        Assert.assertEquals((String)"Invalid number of Violations Reported", (int)size, (int)context.getReport().size());
        Iterator violations = context.getReport().iterator();
        while (violations.hasNext()) {
            RuleViolation violation = (RuleViolation)violations.next();
            reportedValues.add(violation);
            Assert.assertTrue((String)("Unexpected Violation Returned: " + violation), (boolean)values.contains(violation));
        }
        Iterator expected = values.iterator();
        while (expected.hasNext()) {
            RuleViolation violation = (RuleViolation)expected.next();
            Assert.assertTrue((String)("Expected Violation not Returned: " + violation), (boolean)reportedValues.contains(violation));
        }
    }

    protected List makeCompilationUnits() throws Throwable {
        ArrayList<ASTCompilationUnit> RC = new ArrayList<ASTCompilationUnit>();
        JavaParser parser = new JavaParser(new StringReader(this.javaCode));
        RC.add(parser.CompilationUnit());
        return RC;
    }
}

