/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import net.sourceforge.pmd.ast.ASTBlock;
import net.sourceforge.pmd.ast.ASTBlockStatement;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTReturnStatement;
import net.sourceforge.pmd.ast.SimpleNode;
import test.net.sourceforge.pmd.ast.ParserTst;

public class SimpleNodeTest
extends ParserTst {
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTUnmodifiedClassDeclaration;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTName;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTReturnStatement;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTBlockStatement;

    public void testMethodDiffLines() throws Throwable {
        String javaCode = "public class Test {\n";
        javaCode = javaCode + "  public void helloWorld() \n";
        javaCode = javaCode + "  { System.err.println(\"Hello World\"); \n";
        javaCode = javaCode + " } \n";
        javaCode = javaCode + "}";
        Set methods = this.getNodes(class$net$sourceforge$pmd$ast$ASTMethodDeclaration == null ? (class$net$sourceforge$pmd$ast$ASTMethodDeclaration = SimpleNodeTest.class$("net.sourceforge.pmd.ast.ASTMethodDeclaration")) : class$net$sourceforge$pmd$ast$ASTMethodDeclaration, javaCode);
        Iterator iter = methods.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        this.verifyNode((SimpleNode)iter.next(), 2, 3, 4, 2);
    }

    public void testMethodSameColumn() throws Throwable {
        String javaCode = "public class Test {\n";
        javaCode = javaCode + "public void helloWorld() {\n";
        javaCode = javaCode + "} \n";
        javaCode = javaCode + "}\n";
        Set methods = this.getNodes(class$net$sourceforge$pmd$ast$ASTMethodDeclaration == null ? (class$net$sourceforge$pmd$ast$ASTMethodDeclaration = SimpleNodeTest.class$("net.sourceforge.pmd.ast.ASTMethodDeclaration")) : class$net$sourceforge$pmd$ast$ASTMethodDeclaration, javaCode);
        Iterator iter = methods.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        this.verifyNode((SimpleNode)iter.next(), 2, 1, 3, 1);
    }

    public void testMethodSameLine() throws Throwable {
        String javaCode = "public class Test {\n";
        javaCode = javaCode + "  public void helloWorld() {}\n";
        javaCode = javaCode + "}\n";
        Set methods = this.getNodes(class$net$sourceforge$pmd$ast$ASTMethodDeclaration == null ? (class$net$sourceforge$pmd$ast$ASTMethodDeclaration = SimpleNodeTest.class$("net.sourceforge.pmd.ast.ASTMethodDeclaration")) : class$net$sourceforge$pmd$ast$ASTMethodDeclaration, javaCode);
        Iterator iter = methods.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        this.verifyNode((SimpleNode)iter.next(), 2, 3, 2, 29);
    }

    public void testNoLookahead() throws Throwable {
        String javaCode = "public class Foo { }\n";
        Set uCD = this.getNodes(class$net$sourceforge$pmd$ast$ASTUnmodifiedClassDeclaration == null ? (class$net$sourceforge$pmd$ast$ASTUnmodifiedClassDeclaration = SimpleNodeTest.class$("net.sourceforge.pmd.ast.ASTUnmodifiedClassDeclaration")) : class$net$sourceforge$pmd$ast$ASTUnmodifiedClassDeclaration, javaCode);
        Iterator iter = uCD.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        this.verifyNode((SimpleNode)iter.next(), 1, 8, 1, 20);
    }

    public void testNames() throws Throwable {
        String code = "import java.io.File; \n public class Foo{}";
        Set name = this.getNodes(class$net$sourceforge$pmd$ast$ASTName == null ? (class$net$sourceforge$pmd$ast$ASTName = SimpleNodeTest.class$("net.sourceforge.pmd.ast.ASTName")) : class$net$sourceforge$pmd$ast$ASTName, code);
        Iterator i = name.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        while (i.hasNext()) {
            SimpleNode node = (SimpleNode)i.next();
            if (!node.getImage().equals("java.io.File")) continue;
            this.verifyNode(node, 1, 16, 1, 19);
        }
    }

    public void testNames2() throws Throwable {
        String code = "import java.io.\nFile; \n public class Foo{}";
        Set name = this.getNodes(class$net$sourceforge$pmd$ast$ASTName == null ? (class$net$sourceforge$pmd$ast$ASTName = SimpleNodeTest.class$("net.sourceforge.pmd.ast.ASTName")) : class$net$sourceforge$pmd$ast$ASTName, code);
        Iterator i = name.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        while (i.hasNext()) {
            SimpleNode node = (SimpleNode)i.next();
            if (node.getImage().equals("java.io.File")) {
                this.verifyNode(node, 2, 1, 2, 4);
            }
            if (!node.getImage().equals("Foo")) continue;
            this.verifyNode(node, 2, 15, 2, 18);
        }
    }

    public void verifyNode(SimpleNode node, int beginLine, int beginCol, int endLine, int endCol) {
        Assert.assertEquals((String)"Wrong Line Number provided for Start: ", (int)beginLine, (int)node.getBeginLine());
        Assert.assertEquals((String)"Wrong Column provided for Begin: ", (int)beginCol, (int)node.getBeginColumn());
        Assert.assertEquals((String)"Wrong Line Number provided for End: ", (int)endLine, (int)node.getEndLine());
        Assert.assertEquals((String)"Wrong Column provide for End: ", (int)endCol, (int)node.getEndColumn());
    }

    public void testFindChildrenOfType() {
        ASTBlock block = new ASTBlock(2);
        block.jjtAddChild(new ASTReturnStatement(1), 0);
        Assert.assertEquals((int)1, (int)block.findChildrenOfType(class$net$sourceforge$pmd$ast$ASTReturnStatement == null ? (class$net$sourceforge$pmd$ast$ASTReturnStatement = SimpleNodeTest.class$("net.sourceforge.pmd.ast.ASTReturnStatement")) : class$net$sourceforge$pmd$ast$ASTReturnStatement).size());
    }

    public void testFindChildrenOfTypeMultiple() {
        ASTBlock block = new ASTBlock(1);
        block.jjtAddChild(new ASTBlockStatement(2), 0);
        block.jjtAddChild(new ASTBlockStatement(3), 1);
        ArrayList nodes = new ArrayList();
        block.findChildrenOfType(class$net$sourceforge$pmd$ast$ASTBlockStatement == null ? (class$net$sourceforge$pmd$ast$ASTBlockStatement = SimpleNodeTest.class$("net.sourceforge.pmd.ast.ASTBlockStatement")) : class$net$sourceforge$pmd$ast$ASTBlockStatement, nodes);
        Assert.assertEquals((int)2, (int)nodes.size());
    }

    public void testFindChildrenOfTypeRecurse() {
        ASTBlock block = new ASTBlock(1);
        ASTBlock childBlock = new ASTBlock(2);
        block.jjtAddChild(childBlock, 0);
        childBlock.jjtAddChild(new ASTMethodDeclaration(3), 0);
        ArrayList nodes = new ArrayList();
        block.findChildrenOfType(class$net$sourceforge$pmd$ast$ASTMethodDeclaration == null ? (class$net$sourceforge$pmd$ast$ASTMethodDeclaration = SimpleNodeTest.class$("net.sourceforge.pmd.ast.ASTMethodDeclaration")) : class$net$sourceforge$pmd$ast$ASTMethodDeclaration, nodes);
        Assert.assertEquals((int)1, (int)nodes.size());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

