/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.rules.junit;

import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.rules.XPathRule;
import test.net.sourceforge.pmd.rules.RuleTst;

public class JUnitStaticSuiteRuleTest
extends RuleTst {
    private static final String TEST1 = "public class JUnitStaticSuite1 {" + CPD.EOL + " public TestSuite suite() {}" + CPD.EOL + "}";
    private static final String TEST2 = "public class JUnitStaticSuite2 {" + CPD.EOL + " public static TestSuite suite() {}" + CPD.EOL + "}";
    private static final String TEST3 = "public class JUnitStaticSuite3 {" + CPD.EOL + " private static TestSuite suite() {}" + CPD.EOL + "}";
    private Rule rule;

    public void setUp() {
        this.rule = new XPathRule();
        this.rule.addProperty("xpath", "//MethodDeclaration[not(@Static='true') or not(@Public='true')][MethodDeclarator/@Image='suite']");
    }

    public void testNonstatic() throws Throwable {
        this.runTestFromString(TEST1, 1, this.rule);
    }

    public void testGoodOK() throws Throwable {
        this.runTestFromString(TEST2, 0, this.rule);
    }

    public void testPrivateSuite() throws Throwable {
        this.runTestFromString(TEST3, 1, this.rule);
    }
}

