/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.symboltable;

import java.util.HashSet;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.pmd.symboltable.TypeSet;

public class TypeSetTest
extends TestCase {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$net$sourceforge$pmd$PMD;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$util$Set;

    public void testASTCompilationUnitPackage() {
        TypeSet t = new TypeSet();
        t.setASTCompilationUnitPackage("java.lang.");
        Assert.assertEquals((String)"java.lang.", (String)t.getASTCompilationUnitPackage());
    }

    public void testAddImport() {
        TypeSet t = new TypeSet();
        t.addImport("java.io.File");
        Assert.assertEquals((int)1, (int)t.getImportsCount());
    }

    public void testFindClassImplicitImport() throws Throwable {
        TypeSet t = new TypeSet();
        Class clazz = t.findClass("String");
        Assert.assertEquals((Object)(class$java$lang$String == null ? (class$java$lang$String = TypeSetTest.class$("java.lang.String")) : class$java$lang$String), (Object)clazz);
    }

    public void testFindClassSamePackage() throws Throwable {
        TypeSet t = new TypeSet();
        t.setASTCompilationUnitPackage("net.sourceforge.pmd.");
        Class clazz = t.findClass("PMD");
        Assert.assertEquals((Object)(class$net$sourceforge$pmd$PMD == null ? (class$net$sourceforge$pmd$PMD = TypeSetTest.class$("net.sourceforge.pmd.PMD")) : class$net$sourceforge$pmd$PMD), (Object)clazz);
    }

    public void testFindClassExplicitImport() throws Throwable {
        TypeSet t = new TypeSet();
        t.addImport("java.io.File");
        Class clazz = t.findClass("File");
        Assert.assertEquals((Object)(class$java$io$File == null ? (class$java$io$File = TypeSetTest.class$("java.io.File")) : class$java$io$File), (Object)clazz);
    }

    public void testFindClassImportOnDemand() throws Throwable {
        TypeSet t = new TypeSet();
        t.addImport("java.io.*");
        Class clazz = t.findClass("File");
        Assert.assertEquals((Object)(class$java$io$File == null ? (class$java$io$File = TypeSetTest.class$("java.io.File")) : class$java$io$File), (Object)clazz);
    }

    public void testFindClassPrimitive() throws Throwable {
        TypeSet t = new TypeSet();
        Assert.assertEquals(Integer.TYPE, (Object)t.findClass("int"));
    }

    public void testFindClassVoid() throws Throwable {
        TypeSet t = new TypeSet();
        Assert.assertEquals(Void.TYPE, (Object)t.findClass("void"));
    }

    public void testFindFullyQualified() throws Throwable {
        TypeSet t = new TypeSet();
        Assert.assertEquals((Object)(class$java$lang$String == null ? (class$java$lang$String = TypeSetTest.class$("java.lang.String")) : class$java$lang$String), (Object)t.findClass("java.lang.String"));
        Assert.assertEquals((Object)(class$java$util$Set == null ? (class$java$util$Set = TypeSetTest.class$("java.util.Set")) : class$java$util$Set), (Object)t.findClass("java.util.Set"));
    }

    public void testPrimitiveTypeResolver() throws Throwable {
        TypeSet.PrimitiveTypeResolver r = new TypeSet.PrimitiveTypeResolver();
        Assert.assertEquals(Integer.TYPE, (Object)r.resolve("int"));
        Assert.assertEquals(Byte.TYPE, (Object)r.resolve("byte"));
        Assert.assertEquals(Long.TYPE, (Object)r.resolve("long"));
    }

    public void testVoidTypeResolver() throws Throwable {
        TypeSet.VoidResolver r = new TypeSet.VoidResolver();
        Assert.assertEquals(Void.TYPE, (Object)r.resolve("void"));
    }

    public void testExplicitImportResolver() throws Throwable {
        HashSet<String> imports = new HashSet<String>();
        imports.add("java.io.File");
        TypeSet.ExplicitImportResolver r = new TypeSet.ExplicitImportResolver(imports);
        Assert.assertEquals((Object)(class$java$io$File == null ? (class$java$io$File = TypeSetTest.class$("java.io.File")) : class$java$io$File), (Object)r.resolve("File"));
    }

    public void testImplicitImportResolverPass() throws Throwable {
        TypeSet.ImplicitImportResolver r = new TypeSet.ImplicitImportResolver();
        Assert.assertEquals((Object)(class$java$lang$String == null ? (class$java$lang$String = TypeSetTest.class$("java.lang.String")) : class$java$lang$String), (Object)r.resolve("String"));
    }

    public void testImplicitImportResolverPassFail() throws Throwable {
        TypeSet.ImplicitImportResolver r = new TypeSet.ImplicitImportResolver();
        try {
            r.resolve("PMD");
            throw new RuntimeException("Should have thrown an exception");
        }
        catch (ClassNotFoundException cnfe) {
            return;
        }
    }

    public void testCurrentPackageResolverPass() throws Throwable {
        TypeSet.CurrentPackageResolver r = new TypeSet.CurrentPackageResolver("net.sourceforge.pmd.");
        Assert.assertEquals((Object)(class$net$sourceforge$pmd$PMD == null ? (class$net$sourceforge$pmd$PMD = TypeSetTest.class$("net.sourceforge.pmd.PMD")) : class$net$sourceforge$pmd$PMD), (Object)r.resolve("PMD"));
    }

    public void testImportOnDemandResolverPass() throws Throwable {
        HashSet<String> imports = new HashSet<String>();
        imports.add("java.io.*");
        imports.add("java.util.*");
        TypeSet.ImportOnDemandResolver r = new TypeSet.ImportOnDemandResolver(imports);
        Assert.assertEquals((Object)(class$java$util$Set == null ? (class$java$util$Set = TypeSetTest.class$("java.util.Set")) : class$java$util$Set), (Object)r.resolve("Set"));
        Assert.assertEquals((Object)(class$java$io$File == null ? (class$java$io$File = TypeSetTest.class$("java.io.File")) : class$java$io$File), (Object)r.resolve("File"));
    }

    public void testImportOnDemandResolverFail() throws Throwable {
        HashSet<String> imports = new HashSet<String>();
        imports.add("java.io.*");
        imports.add("java.util.*");
        TypeSet.ImportOnDemandResolver r = new TypeSet.ImportOnDemandResolver(imports);
        try {
            r.resolve("foo");
            throw new RuntimeException("Should have thrown an exception");
        }
        catch (ClassNotFoundException cnfe) {
            try {
                r.resolve("String");
                throw new RuntimeException("Should have thrown an exception");
            }
            catch (ClassNotFoundException cnfe2) {
                return;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

