/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.util.Objects;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeLiteral<T> {
    final Class<? super T> rawType;
    final Type type;
    final int hashCode;

    protected TypeLiteral() {
        this.type = TypeLiteral.getSuperclassTypeParameter(this.getClass());
        this.rawType = TypeLiteral.getRawType(this.type);
        this.hashCode = TypeLiteral.hashCode(this.type);
    }

    TypeLiteral(Type type) {
        this.rawType = TypeLiteral.getRawType(Objects.nonNull(type, "type"));
        this.type = type;
        this.hashCode = TypeLiteral.hashCode(type);
    }

    static Type getSuperclassTypeParameter(Class<?> subclass) {
        Type superclass = subclass.getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        return ((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    static TypeLiteral<?> fromSuperclassTypeParameter(Class<?> subclass) {
        return new SimpleTypeLiteral(TypeLiteral.getSuperclassTypeParameter(subclass));
    }

    private static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (!(rawType instanceof Class)) {
                throw TypeLiteral.unexpectedType(rawType, Class.class);
            }
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            return Object[].class;
        }
        throw TypeLiteral.unexpectedType(type, ParameterizedType.class);
    }

    Class<? super T> getRawType() {
        return this.rawType;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeLiteral)) {
            return false;
        }
        TypeLiteral other = (TypeLiteral)o;
        return TypeLiteral.equals(this.type, other.type);
    }

    public String toString() {
        return this.type instanceof Class ? ((Class)this.type).getName() : this.type.toString();
    }

    static AssertionError unexpectedType(Type type, Class<?> expected) {
        return new AssertionError((Object)("Unexpected type. Expected: " + expected.getName() + ", got: " + type.getClass().getName() + ", for type literal: " + type.toString() + "."));
    }

    public static TypeLiteral<?> get(Type type) {
        return new SimpleTypeLiteral(type);
    }

    public static <T> TypeLiteral<T> get(Class<T> type) {
        return new SimpleTypeLiteral(type);
    }

    static int hashCode(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            int h = p.getRawType().hashCode();
            for (Type argument : p.getActualTypeArguments()) {
                h = h * 31 + TypeLiteral.hashCode(argument);
            }
            return h;
        }
        if (type instanceof Class) {
            return type.hashCode();
        }
        if (type instanceof GenericArrayType) {
            return TypeLiteral.hashCode(((GenericArrayType)type).getGenericComponentType()) * 31;
        }
        return type.hashCode();
    }

    static boolean equals(Type a, Type b) {
        if (a instanceof Class) {
            return a.equals(b);
        }
        if (a instanceof ParameterizedType) {
            Type[] ba;
            if (!(b instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType pa = (ParameterizedType)a;
            ParameterizedType pb = (ParameterizedType)b;
            if (!pa.getRawType().equals(pb.getRawType())) {
                return false;
            }
            Type[] aa = pa.getActualTypeArguments();
            if (aa.length != (ba = pb.getActualTypeArguments()).length) {
                return false;
            }
            for (int i = 0; i < aa.length; ++i) {
                if (TypeLiteral.equals(aa[i], ba[i])) continue;
                return false;
            }
            return true;
        }
        if (a instanceof GenericArrayType) {
            if (!(b instanceof GenericArrayType)) {
                return false;
            }
            return TypeLiteral.equals(((GenericArrayType)a).getGenericComponentType(), ((GenericArrayType)b).getGenericComponentType());
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleTypeLiteral<T>
    extends TypeLiteral<T> {
        public SimpleTypeLiteral(Type type) {
            super(type);
        }
    }
}

