/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class HostInterface {
    public static boolean USE_LOOPBACK_ADDR = false;
    public static boolean USE_ONLY_IPV4_ADDR = true;
    public static boolean USE_ONLY_IPV6_ADDR = false;
    private static String ifAddress = "";

    public static final String getInterface() {
        return ifAddress;
    }

    private static final boolean hasAssignedInterface() {
        return 0 < ifAddress.length();
    }

    private static final boolean isUsableAddress(InetAddress addr) {
        if (!USE_LOOPBACK_ADDR && addr.isLoopbackAddress()) {
            return false;
        }
        if (USE_ONLY_IPV4_ADDR && addr instanceof Inet6Address) {
            return false;
        }
        return !USE_ONLY_IPV6_ADDR || !(addr instanceof Inet4Address);
    }

    public static final int getNHostAddresses() {
        if (HostInterface.hasAssignedInterface()) {
            return 1;
        }
        int nHostAddrs = 0;
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!HostInterface.isUsableAddress(addr)) continue;
                    ++nHostAddrs;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nHostAddrs;
    }

    public static final String getHostAddress(int n) {
        if (HostInterface.hasAssignedInterface()) {
            return HostInterface.getInterface();
        }
        int hostAddrCnt = 0;
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!HostInterface.isUsableAddress(addr)) continue;
                    if (hostAddrCnt < n) {
                        ++hostAddrCnt;
                        continue;
                    }
                    String host = addr.getHostAddress();
                    return host;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static final boolean isIPv6Address(String host) {
        try {
            InetAddress addr = InetAddress.getByName(host);
            return addr instanceof Inet6Address;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final boolean isIPv4Address(String host) {
        try {
            InetAddress addr = InetAddress.getByName(host);
            return addr instanceof Inet4Address;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final boolean hasIPv4Addresses() {
        int addrCnt = HostInterface.getNHostAddresses();
        for (int n = 0; n < addrCnt; ++n) {
            String addr = HostInterface.getHostAddress(n);
            if (!HostInterface.isIPv4Address(addr)) continue;
            return true;
        }
        return false;
    }

    public static final boolean hasIPv6Addresses() {
        int addrCnt = HostInterface.getNHostAddresses();
        for (int n = 0; n < addrCnt; ++n) {
            String addr = HostInterface.getHostAddress(n);
            if (!HostInterface.isIPv6Address(addr)) continue;
            return true;
        }
        return false;
    }

    public static final String getIPv4Address() {
        int addrCnt = HostInterface.getNHostAddresses();
        for (int n = 0; n < addrCnt; ++n) {
            String addr = HostInterface.getHostAddress(n);
            if (!HostInterface.isIPv4Address(addr)) continue;
            return addr;
        }
        return "";
    }

    public static final String getIPv6Address() {
        int addrCnt = HostInterface.getNHostAddresses();
        for (int n = 0; n < addrCnt; ++n) {
            String addr = HostInterface.getHostAddress(n);
            if (!HostInterface.isIPv6Address(addr)) continue;
            return addr;
        }
        return "";
    }

    public static final String getHostURL(String host, int port, String uri) {
        String hostAddr = host;
        if (HostInterface.isIPv6Address(host)) {
            hostAddr = "[" + host + "]";
        }
        return "http://" + hostAddr + ":" + Integer.toString(port) + uri;
    }
}

