/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.SparseDoubleMatrix1D;
import edu.uci.ics.jung.algorithms.GraphMatrixOperations;
import edu.uci.ics.jung.algorithms.importance.NodeRanking;
import edu.uci.ics.jung.algorithms.importance.PageRank;
import edu.uci.ics.jung.algorithms.importance.RelativeAuthorityRanker;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Element;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.Indexer;
import edu.uci.ics.jung.utils.MutableDouble;
import edu.uci.ics.jung.utils.UserData;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MarkovCentrality
extends RelativeAuthorityRanker {
    public static final String MEAN_FIRST_PASSAGE_TIME = "jung.algorithms.importance.mean_first_passage_time";
    private DoubleMatrix1D mRankings;
    private Indexer mIndexer;

    public MarkovCentrality(DirectedGraph graph, Set rootNodes) {
        this(graph, rootNodes, null);
    }

    public MarkovCentrality(DirectedGraph graph, Set rootNodes, String edgeWeightKey) {
        super.initialize(graph, true, false);
        this.setPriors(rootNodes);
        if (edgeWeightKey == null) {
            this.assignDefaultEdgeTransitionWeights();
        } else {
            this.setUserDefinedEdgeWeightKey(edgeWeightKey);
        }
        this.normalizeEdgeTransitionWeights();
        this.mIndexer = Indexer.getIndexer(graph);
        this.mRankings = new SparseDoubleMatrix1D(graph.numVertices());
    }

    public String getRankScoreKey() {
        return MEAN_FIRST_PASSAGE_TIME;
    }

    public double getRankScore(Element vert) {
        ArchetypeVertex v = (ArchetypeVertex)vert;
        return this.mRankings.get(this.mIndexer.getIndex(v));
    }

    protected void setRankScore(Element v, double rankValue) {
        v.setUserDatum(this.getRankScoreKey(), new MutableDouble(rankValue), UserData.SHARED);
    }

    protected double evaluateIteration() {
        DoubleMatrix2D mFPTMatrix = GraphMatrixOperations.computeMeanFirstPassageMatrix(this.getGraph(), this.getEdgeWeightKeyName(), this.getStationaryDistribution());
        this.mRankings.assign(0.0);
        Iterator p_iter = this.getPriors().iterator();
        while (p_iter.hasNext()) {
            Vertex p = (Vertex)p_iter.next();
            int p_id = this.mIndexer.getIndex(p);
            Iterator v_iter = this.getVertices().iterator();
            while (v_iter.hasNext()) {
                Vertex v = (Vertex)v_iter.next();
                int v_id = this.mIndexer.getIndex(v);
                this.mRankings.set(v_id, this.mRankings.get(v_id) + mFPTMatrix.get(p_id, v_id));
            }
        }
        Iterator v_iter = this.getVertices().iterator();
        while (v_iter.hasNext()) {
            Vertex v = (Vertex)v_iter.next();
            int v_id = this.mIndexer.getIndex(v);
            this.mRankings.set(v_id, 1.0 / (this.mRankings.get(v_id) / (double)this.getPriors().size()));
        }
        double total = this.mRankings.zSum();
        Iterator v_iter2 = this.getVertices().iterator();
        while (v_iter2.hasNext()) {
            Vertex v = (Vertex)v_iter2.next();
            int v_id = this.mIndexer.getIndex(v);
            this.mRankings.set(v_id, this.mRankings.get(v_id) / total);
        }
        return 0.0;
    }

    private DoubleMatrix1D getStationaryDistribution() {
        DenseDoubleMatrix1D piVector = new DenseDoubleMatrix1D(this.getVertices().size());
        PageRank pageRank = new PageRank((DirectedGraph)this.getGraph(), 0.0, this.getEdgeWeightKeyName());
        pageRank.evaluate();
        List rankings = pageRank.getRankings();
        Iterator r_iter = rankings.iterator();
        while (r_iter.hasNext()) {
            NodeRanking rank = (NodeRanking)r_iter.next();
            piVector.set(this.mIndexer.getIndex(rank.vertex), rank.rankScore);
        }
        return piVector;
    }
}

