/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.AbstractRanker;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Element;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.SparseVertex;
import edu.uci.ics.jung.utils.GraphUtils;
import edu.uci.ics.jung.utils.MutableDouble;
import edu.uci.ics.jung.utils.UserData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class WeightedNIPaths
extends AbstractRanker {
    public static final String WEIGHTED_NIPATHS_KEY = "jung.algorithms.importance.WEIGHTED_NIPATHS_KEY";
    private double mAlpha;
    private int mMaxDepth;
    private Set mPriors;
    private static final String PATH_INDEX_KEY = "WeightedNIPathsII.PathIndexKey";
    private static final String ROOT_KEY = "WeightedNIPathsII.RootKey";
    private static final String PATHS_SEEN_KEY = "WeightedNIPathsII.PathsSeenKey";

    public WeightedNIPaths(DirectedGraph graph, double alpha, int maxDepth, Set priors) {
        super.initialize(graph, true, false);
        this.mAlpha = alpha;
        this.mMaxDepth = maxDepth;
        this.mPriors = priors;
        Iterator vIt = graph.getVertices().iterator();
        while (vIt.hasNext()) {
            Vertex currentVertex = (Vertex)vIt.next();
            currentVertex.setUserDatum(WEIGHTED_NIPATHS_KEY, new MutableDouble(0.0), UserData.SHARED);
        }
    }

    public String getRankScoreKey() {
        return WEIGHTED_NIPATHS_KEY;
    }

    protected void incrementRankScore(Element v, double rankValue) {
        this.setRankScore(v, this.getRankScore(v) + rankValue);
    }

    protected void computeWeightedPathsFromSource(Vertex root, int depth) {
        int pathIdx = 1;
        Iterator rootEdgeIt = root.getOutEdges().iterator();
        while (rootEdgeIt.hasNext()) {
            DirectedEdge currentEdge = (DirectedEdge)rootEdgeIt.next();
            Integer pathIdxValue = new Integer(pathIdx);
            currentEdge.setUserDatum(PATH_INDEX_KEY, pathIdxValue, UserData.REMOVE);
            currentEdge.setUserDatum(ROOT_KEY, root, UserData.REMOVE);
            this.newVertexEncountered(pathIdxValue, currentEdge.getDest(), root);
            ++pathIdx;
        }
        ArrayList<Edge> edges = new ArrayList<Edge>();
        Vertex virtualNode = this.getGraph().addVertex(new SparseVertex());
        Edge virtualSinkEdge = GraphUtils.addEdge(this.getGraph(), virtualNode, root);
        edges.add(virtualSinkEdge);
        for (int currentDepth = 0; currentDepth <= depth; ++currentDepth) {
            double currentWeight = Math.pow(this.mAlpha, -1.0 * (double)currentDepth);
            Iterator it = edges.iterator();
            while (it.hasNext()) {
                DirectedEdge currentEdge = (DirectedEdge)it.next();
                this.incrementRankScore(currentEdge.getDest(), currentWeight);
            }
            if (currentDepth == depth || edges.size() == 0) break;
            ArrayList<DirectedEdge> newEdges = new ArrayList<DirectedEdge>();
            Iterator sourceEdgeIt = edges.iterator();
            while (sourceEdgeIt.hasNext()) {
                DirectedEdge currentSourceEdge = (DirectedEdge)sourceEdgeIt.next();
                Integer sourcePathIndex = (Integer)currentSourceEdge.getUserDatum(PATH_INDEX_KEY);
                Iterator edgeIt = currentSourceEdge.getDest().getOutEdges().iterator();
                while (edgeIt.hasNext()) {
                    DirectedEdge currentDestEdge = (DirectedEdge)edgeIt.next();
                    Vertex destEdgeRoot = (Vertex)currentDestEdge.getUserDatum(ROOT_KEY);
                    Vertex destEdgeDest = currentDestEdge.getDest();
                    if (currentSourceEdge == virtualSinkEdge) {
                        newEdges.add(currentDestEdge);
                        continue;
                    }
                    if (destEdgeRoot == root || destEdgeDest == currentSourceEdge.getSource()) continue;
                    Set pathsSeen = (Set)destEdgeDest.getUserDatum(PATHS_SEEN_KEY);
                    if (pathsSeen == null) {
                        this.newVertexEncountered(sourcePathIndex, destEdgeDest, root);
                    } else if (destEdgeDest.getUserDatum(ROOT_KEY) != root) {
                        destEdgeDest.setUserDatum(ROOT_KEY, root, UserData.REMOVE);
                        pathsSeen.clear();
                        pathsSeen.add(sourcePathIndex);
                    } else {
                        if (pathsSeen.contains(sourcePathIndex)) continue;
                        pathsSeen.add(sourcePathIndex);
                    }
                    currentDestEdge.setUserDatum(PATH_INDEX_KEY, sourcePathIndex, UserData.REMOVE);
                    currentDestEdge.setUserDatum(ROOT_KEY, root, UserData.REMOVE);
                    newEdges.add(currentDestEdge);
                }
            }
            edges = newEdges;
        }
        this.getGraph().removeVertex(virtualNode);
    }

    private void newVertexEncountered(Integer sourcePathIndex, Vertex dest, Vertex root) {
        HashSet<Integer> pathsSeen = new HashSet<Integer>();
        pathsSeen.add(sourcePathIndex);
        dest.setUserDatum(PATHS_SEEN_KEY, pathsSeen, UserData.REMOVE);
        dest.setUserDatum(ROOT_KEY, root, UserData.REMOVE);
    }

    protected double evaluateIteration() {
        Iterator it = this.mPriors.iterator();
        while (it.hasNext()) {
            this.computeWeightedPathsFromSource((Vertex)it.next(), this.mMaxDepth);
        }
        this.normalizeRankings();
        return 0.0;
    }

    protected void onFinalize(Element udc) {
        udc.removeUserDatum(PATH_INDEX_KEY);
        udc.removeUserDatum(ROOT_KEY);
        udc.removeUserDatum(PATHS_SEEN_KEY);
    }
}

