package coboled.editors;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.SWT;

public class CobolScanner extends RuleBasedScanner {

	public CobolScanner(ColorManager manager) {
		List<IRule> rules = new ArrayList<IRule>();
		addQuotesRule(rules, manager);
		addWordRule(rules, manager);
		addWhitespaceRule(rules, manager);
		setRules(rules.toArray(new IRule[rules.size()]));
	}

	private void addQuotesRule(List<IRule> rules, ColorManager manager) {
		IToken string =
			new Token(
				new TextAttribute(manager.getColor(ICobolColorConstants.STRING)));
		// Add rule for double quotes
		rules.add(new SingleLineRule("\"", "\"", string, '\\'));
		// Add a rule for single quotes
		rules.add(new SingleLineRule("'", "'", string, '\\'));
	}

	private void addWordRule(List<IRule> rules, ColorManager manager) {
		IToken keyword =
			new Token(
				new TextAttribute(manager.getColor(ICobolColorConstants.KEYWORD), null, SWT.BOLD));
		IToken other =
			new Token(
				new TextAttribute(manager.getColor(ICobolColorConstants.DEFAULT)));

		WordRule wordRule = new WordRule(new CobolWordDetector(), other, false);
		for(int i = 0; i < ICobolKeyWordConstants.KEYWORDS.length; i++) {
			wordRule.addWord(ICobolKeyWordConstants.KEYWORDS[i], keyword);
		}
		rules.add(wordRule);
	}

	private void addWhitespaceRule(List<IRule> rules, ColorManager manager) {
		rules.add(new WhitespaceRule(new CobolWhitespaceDetector()));
	}
}
