namespace app {
    'use strict';

    var appName = 'zephyr';
    export var zephyr = angular.module(appName, ['ui.router', 'ngResource', 'ui.bootstrap']);


    zephyr.config(($stateProvider, $urlRouterProvider, $locationProvider) => {

        $urlRouterProvider.otherwise('/execution');

        $locationProvider.html5Mode({
            enabled: true,
            requireBase: false
        });

        $stateProvider
            .state('execution', {
                url: '/execution',
                templateUrl: 'templates/execution.html',
                controller: 'executionController',
                controllerAs: 'c'
            })
        .state('files', {
            url: '/files',
            templateUrl: 'templates/files.html',
            controller: 'filesController',
            controllerAs: 'c'
        })
        .state('history', {
            url: '/history',
            templateUrl: 'templates/history.html',
            controller: 'historyController',
            controllerAs: 'c'
        })
    });

    zephyr.service('APIEndPoint', services.APIEndPoint);
    zephyr.service('MyModal', services.MyModal);

    zephyr.controller('executionController', controllers.Execution);
    zephyr.controller('filesController', controllers.Files);
    zephyr.controller('historyController', controllers.History);
    zephyr.controller('commandController', directives.CommandController);
    zephyr.controller('optionController', directives.OptionController);

    zephyr.directive('headerMenu', directives.HeaderMenu.Factory());
    zephyr.directive('command', directives.Command.Factory());
    zephyr.directive('option', directives.Option.Factory());

}
