require 'test_helper'

class HistologiesControllerTest < ActionController::TestCase
  setup do
    @histology = histologies(:one)
  end

  test "should get index" do
    get :index
    assert_response :success
    assert_not_nil assigns(:histologies)
  end

  test "should get new" do
    get :new
    assert_response :success
  end

  test "should create histology" do
    assert_difference('Histology.count') do
      post :create, histology: @histology.attributes
    end

    assert_redirected_to histology_path(assigns(:histology))
  end

  test "should show histology" do
    get :show, id: @histology
    assert_response :success
  end

  test "should get edit" do
    get :edit, id: @histology
    assert_response :success
  end

  test "should update histology" do
    put :update, id: @histology, histology: @histology.attributes
    assert_redirected_to histology_path(assigns(:histology))
  end

  test "should destroy histology" do
    assert_difference('Histology.count', -1) do
      delete :destroy, id: @histology
    end

    assert_redirected_to histologies_path
  end
end
