#!/usr/bin/perl

use strict;
use LWP::UserAgent;
use HTTP::Request::Common;
use URI::Escape;
use Encode;
use utf8;

my $file = $ARGV[0] || die;
my $url_base = 'http://sourceforge.jp/projects/g15jp/wiki/';

my $url = $url_base . $file;

open(IF, $file) || die;
my $tmp = $/;
$/ = undef;
my $text = <IF>;
close(IF);
$text = decode('utf8', $text);

my $ua = LWP::UserAgent -> new();

my $req = GET($url . '?action=edit');
my $res = $ua->request($req);

my $key;
if ($res->as_string() =~ /name="postkey" value="([^"]+)"/) {
	$key = $1;
} else {
	die 'can not find key' . $res->as_string();
}

my %data = (action => 'update',
	    title => uri_unescape($file),
	    text => $text,
	    comment => '',
	    commit => '保存',
	    textarea_height => 24,
	    postkey => $key);


my $req2 = POST($url . '?action=update', \%data);
my $res2 = $ua->request($req2);

#print $res->as_string;
