/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include <gegl.h>

#include "libgimpbase/gimpbase.h"
#include "libgimpcolor/gimpcolor.h"

#include "pdb-types.h"

#include "core/gimpchannel-select.h"
#include "core/gimpdrawable.h"
#include "core/gimpimage.h"
#include "core/gimpitem.h"
#include "core/gimpparamspecs.h"

#include "gimppdb.h"
#include "gimppdb-utils.h"
#include "gimppdbcontext.h"
#include "gimpprocedure.h"
#include "internal-procs.h"

#include "gimp-intl.h"


static GValueArray *
image_select_color_invoker (GimpProcedure      *procedure,
                            Gimp               *gimp,
                            GimpContext        *context,
                            GimpProgress       *progress,
                            const GValueArray  *args,
                            GError            **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  GimpDrawable *drawable;
  GimpRGB color;
  gint32 threshold;
  gint32 operation;
  gboolean sample_merged;
  gboolean select_transparent;
  gint32 select_criterion;

  image = gimp_value_get_image (&args->values[0], gimp);
  drawable = gimp_value_get_drawable (&args->values[1], gimp);
  gimp_value_get_rgb (&args->values[2], &color);
  threshold = g_value_get_int (&args->values[3]);
  operation = g_value_get_enum (&args->values[4]);
  sample_merged = g_value_get_boolean (&args->values[5]);
  select_transparent = g_value_get_boolean (&args->values[6]);
  select_criterion = g_value_get_enum (&args->values[7]);

  if (success)
    {
      if (sample_merged ||
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), image, FALSE, error))
        {
          GimpPDBContext *pdb_context = GIMP_PDB_CONTEXT (context);

          gimp_channel_select_by_color (gimp_image_get_mask (image), drawable,
                                        sample_merged,
                                        &color,
                                        threshold,
                                        select_transparent,
                                        select_criterion,
                                        operation,
                                        pdb_context->antialias,
                                        pdb_context->feather,
                                        pdb_context->feather_radius_x,
                                        pdb_context->feather_radius_y);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
image_select_ellipse_invoker (GimpProcedure      *procedure,
                              Gimp               *gimp,
                              GimpContext        *context,
                              GimpProgress       *progress,
                              const GValueArray  *args,
                              GError            **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gdouble x;
  gdouble y;
  gdouble width;
  gdouble height;
  gint32 operation;

  image = gimp_value_get_image (&args->values[0], gimp);
  x = g_value_get_double (&args->values[1]);
  y = g_value_get_double (&args->values[2]);
  width = g_value_get_double (&args->values[3]);
  height = g_value_get_double (&args->values[4]);
  operation = g_value_get_enum (&args->values[5]);

  if (success)
    {
      GimpPDBContext *pdb_context = GIMP_PDB_CONTEXT (context);

      gimp_channel_select_ellipse (gimp_image_get_mask (image),
                                   (gint) x, (gint) y,
                                   (gint) width, (gint) height,
                                   operation,
                                   pdb_context->antialias,
                                   pdb_context->feather,
                                   pdb_context->feather_radius_x,
                                   pdb_context->feather_radius_y,
                                   TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
image_select_polygon_invoker (GimpProcedure      *procedure,
                              Gimp               *gimp,
                              GimpContext        *context,
                              GimpProgress       *progress,
                              const GValueArray  *args,
                              GError            **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint32 num_segs;
  const gdouble *segs;
  gint32 operation;

  image = gimp_value_get_image (&args->values[0], gimp);
  num_segs = g_value_get_int (&args->values[1]);
  segs = gimp_value_get_floatarray (&args->values[2]);
  operation = g_value_get_enum (&args->values[3]);

  if (success)
    {
      GimpPDBContext *pdb_context = GIMP_PDB_CONTEXT (context);

      gimp_channel_select_polygon (gimp_image_get_mask (image),
                                   _("Free Select"),
                                   num_segs / 2,
                                   (GimpVector2 *) segs,
                                   operation,
                                   pdb_context->antialias,
                                   pdb_context->feather,
                                   pdb_context->feather_radius_x,
                                   pdb_context->feather_radius_y,
                                   TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
image_select_fuzzy_invoker (GimpProcedure      *procedure,
                            Gimp               *gimp,
                            GimpContext        *context,
                            GimpProgress       *progress,
                            const GValueArray  *args,
                            GError            **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  GimpDrawable *drawable;
  gdouble x;
  gdouble y;
  gint32 threshold;
  gint32 operation;
  gboolean sample_merged;
  gboolean select_transparent;
  gint32 select_criterion;

  image = gimp_value_get_image (&args->values[0], gimp);
  drawable = gimp_value_get_drawable (&args->values[1], gimp);
  x = g_value_get_double (&args->values[2]);
  y = g_value_get_double (&args->values[3]);
  threshold = g_value_get_int (&args->values[4]);
  operation = g_value_get_enum (&args->values[5]);
  sample_merged = g_value_get_boolean (&args->values[6]);
  select_transparent = g_value_get_boolean (&args->values[7]);
  select_criterion = g_value_get_enum (&args->values[8]);

  if (success)
    {
      if (sample_merged ||
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), image, FALSE, error))
        {
          GimpPDBContext *pdb_context = GIMP_PDB_CONTEXT (context);

          gimp_channel_select_fuzzy (gimp_image_get_mask (image),
                                     drawable,
                                     sample_merged,
                                     x, y,
                                     threshold,
                                     select_transparent,
                                     select_criterion,
                                     operation,
                                     pdb_context->antialias,
                                     pdb_context->feather,
                                     pdb_context->feather_radius_x,
                                     pdb_context->feather_radius_y);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
image_select_rectangle_invoker (GimpProcedure      *procedure,
                                Gimp               *gimp,
                                GimpContext        *context,
                                GimpProgress       *progress,
                                const GValueArray  *args,
                                GError            **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gdouble x;
  gdouble y;
  gdouble width;
  gdouble height;
  gint32 operation;

  image = gimp_value_get_image (&args->values[0], gimp);
  x = g_value_get_double (&args->values[1]);
  y = g_value_get_double (&args->values[2]);
  width = g_value_get_double (&args->values[3]);
  height = g_value_get_double (&args->values[4]);
  operation = g_value_get_enum (&args->values[5]);

  if (success)
    {
      GimpPDBContext *pdb_context = GIMP_PDB_CONTEXT (context);

      gimp_channel_select_rectangle (gimp_image_get_mask (image),
                                     (gint) x, (gint) y,
                                     (gint) width, (gint) height,
                                     operation,
                                     pdb_context->feather,
                                     pdb_context->feather_radius_x,
                                     pdb_context->feather_radius_y,
                                     TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
image_select_round_rectangle_invoker (GimpProcedure      *procedure,
                                      Gimp               *gimp,
                                      GimpContext        *context,
                                      GimpProgress       *progress,
                                      const GValueArray  *args,
                                      GError            **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gdouble x;
  gdouble y;
  gdouble width;
  gdouble height;
  gdouble corner_radius_x;
  gdouble corner_radius_y;
  gint32 operation;

  image = gimp_value_get_image (&args->values[0], gimp);
  x = g_value_get_double (&args->values[1]);
  y = g_value_get_double (&args->values[2]);
  width = g_value_get_double (&args->values[3]);
  height = g_value_get_double (&args->values[4]);
  corner_radius_x = g_value_get_double (&args->values[5]);
  corner_radius_y = g_value_get_double (&args->values[6]);
  operation = g_value_get_enum (&args->values[7]);

  if (success)
    {
      GimpPDBContext *pdb_context = GIMP_PDB_CONTEXT (context);

      gimp_channel_select_round_rect (gimp_image_get_mask (image),
                                      (gint) x, (gint) y,
                                      (gint) width, (gint) height,
                                      corner_radius_x,
                                      corner_radius_y,
                                      operation,
                                      pdb_context->antialias,
                                      pdb_context->feather,
                                      pdb_context->feather_radius_x,
                                      pdb_context->feather_radius_y,
                                      TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
image_select_item_invoker (GimpProcedure      *procedure,
                           Gimp               *gimp,
                           GimpContext        *context,
                           GimpProgress       *progress,
                           const GValueArray  *args,
                           GError            **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  GimpItem *item;
  gint32 operation;

  image = gimp_value_get_image (&args->values[0], gimp);
  item = gimp_value_get_item (&args->values[1], gimp);
  operation = g_value_get_enum (&args->values[2]);

  if (success)
    {
      if (gimp_pdb_item_is_attached (item, image, FALSE, error))
        {
          GimpPDBContext *pdb_context = GIMP_PDB_CONTEXT (context);

          gimp_item_to_selection (item, operation,
                                  pdb_context->antialias,
                                  pdb_context->feather,
                                  pdb_context->feather_radius_x,
                                  pdb_context->feather_radius_y);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_image_select_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-image-select-color
   */
  procedure = gimp_procedure_new (image_select_color_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-select-color");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-image-select-color",
                                     "Create a selection by selecting all pixels (in the specified drawable) with the same (or similar) color to that specified.",
                                     "This tool creates a selection over the specified image. A by-color selection is determined by the supplied color under the constraints of the specified threshold. Essentially, all pixels (in the drawable) that have color sufficiently close to the specified color (as determined by the threshold value) are included in the selection. To select transparent regions, the color specified must also have minimum alpha. If the 'sample-merged' parameter is TRUE, the data of the composite image will be used instead of that for the specified drawable. This is equivalent to sampling for colors after merging all visible layers. In the case of a merged sampling, the supplied drawable is ignored.",
                                     "David Gowers",
                                     "David Gowers",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The affected image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_rgb ("color",
                                                    "color",
                                                    "The color to select",
                                                    FALSE,
                                                    NULL,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("threshold",
                                                      "threshold",
                                                      "Threshold in intensity levels",
                                                      0, 255, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("operation",
                                                  "operation",
                                                  "The selection operation",
                                                  GIMP_TYPE_CHANNEL_OPS,
                                                  GIMP_CHANNEL_OP_ADD,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("sample-merged",
                                                     "sample merged",
                                                     "Use the composite image, not the drawable",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("select-transparent",
                                                     "select transparent",
                                                     "Whether to consider transparent pixels for selection. If TRUE, transparency is considered as a unique selectable color.",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("select-criterion",
                                                  "select criterion",
                                                  "The criterion used to determine color similarity. SELECT_CRITERION_COMPOSITE is the standard choice.",
                                                  GIMP_TYPE_SELECT_CRITERION,
                                                  GIMP_SELECT_CRITERION_COMPOSITE,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-select-ellipse
   */
  procedure = gimp_procedure_new (image_select_ellipse_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-select-ellipse");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-image-select-ellipse",
                                     "Create an elliptical selection over the specified image.",
                                     "This tool creates an elliptical selection over the specified image. The elliptical region can be either added to, subtracted from, or replace the contents of the previous selection mask.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x",
                                                    "x",
                                                    "x coordinate of upper-left corner of ellipse bounding box",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y",
                                                    "y",
                                                    "y coordinate of upper-left corner of ellipse bounding box",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("width",
                                                    "width",
                                                    "The width of the ellipse",
                                                    0, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("height",
                                                    "height",
                                                    "The height of the ellipse",
                                                    0, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("operation",
                                                  "operation",
                                                  "The selection operation",
                                                  GIMP_TYPE_CHANNEL_OPS,
                                                  GIMP_CHANNEL_OP_ADD,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-select-polygon
   */
  procedure = gimp_procedure_new (image_select_polygon_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-select-polygon");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-image-select-polygon",
                                     "Create a polygonal selection over the specified image.",
                                     "This tool creates a polygonal selection over the specified image. The polygonal region can be either added to, subtracted from, or replace the contents of the previous selection mask. The polygon is specified through an array of floating point numbers and its length. The length of array must be 2n, where n is the number of points. Each point is defined by 2 floating point values which correspond to the x and y coordinates. If the final point does not connect to the starting point, a connecting segment is automatically added.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-segs",
                                                      "num segs",
                                                      "Number of points (count 1 coordinate as two points)",
                                                      2, G_MAXINT32, 2,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_float_array ("segs",
                                                            "segs",
                                                            "Array of points: { p1.x, p1.y, p2.x, p2.y, ..., pn.x, pn.y}",
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("operation",
                                                  "operation",
                                                  "The selection operation",
                                                  GIMP_TYPE_CHANNEL_OPS,
                                                  GIMP_CHANNEL_OP_ADD,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-select-fuzzy
   */
  procedure = gimp_procedure_new (image_select_fuzzy_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-select-fuzzy");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-image-select-fuzzy",
                                     "Create a fuzzy selection starting at the specified coordinates on the specified drawable.",
                                     "This tool creates a fuzzy selection over the specified image. A fuzzy selection is determined by a seed fill under the constraints of the specified threshold. Essentially, the color at the specified coordinates (in the drawable) is measured and the selection expands outwards from that point to any adjacent pixels which are not significantly different (as determined by the threshold value). This process continues until no more expansion is possible. If antialiasing is turned on, the final selection mask will contain intermediate values based on close misses to the threshold bar at pixels along the seed fill boundary. If the 'sample-merged' parameter is TRUE, the data of the composite image will be used instead of that for the specified drawable. This is equivalent to sampling for colors after merging all visible layers. In the case of a merged sampling, the supplied drawable is ignored. If the sample is merged, the specified coordinates are relative to the image origin; otherwise,"
  "they are relative to the drawable's origin.",
                                     "David Gowers",
                                     "David Gowers",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The affected image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x",
                                                    "x",
                                                    "x coordinate of initial seed fill point: (image coordinates)",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y",
                                                    "y",
                                                    "y coordinate of initial seed fill point: (image coordinates)",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("threshold",
                                                      "threshold",
                                                      "Threshold in intensity levels",
                                                      0, 255, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("operation",
                                                  "operation",
                                                  "The selection operation",
                                                  GIMP_TYPE_CHANNEL_OPS,
                                                  GIMP_CHANNEL_OP_ADD,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("sample-merged",
                                                     "sample merged",
                                                     "Use the composite image, not the drawable",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("select-transparent",
                                                     "select transparent",
                                                     "Whether to consider transparent pixels for selection. If TRUE, transparency is considered as a unique selectable color.",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("select-criterion",
                                                  "select criterion",
                                                  "The criterion used to determine color similarity. SELECT_CRITERION_COMPOSITE is the standard choice.",
                                                  GIMP_TYPE_SELECT_CRITERION,
                                                  GIMP_SELECT_CRITERION_COMPOSITE,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-select-rectangle
   */
  procedure = gimp_procedure_new (image_select_rectangle_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-select-rectangle");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-image-select-rectangle",
                                     "Create a rectangular selection over the specified image;",
                                     "This tool creates a rectangular selection over the specified image. The rectangular region can be either added to, subtracted from, or replace the contents of the previous selection mask.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x",
                                                    "x",
                                                    "x coordinate of upper-left corner of rectangle",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y",
                                                    "y",
                                                    "y coordinate of upper-left corner of rectangle",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("width",
                                                    "width",
                                                    "The width of the rectangle",
                                                    0, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("height",
                                                    "height",
                                                    "The height of the rectangle",
                                                    0, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("operation",
                                                  "operation",
                                                  "The selection operation",
                                                  GIMP_TYPE_CHANNEL_OPS,
                                                  GIMP_CHANNEL_OP_ADD,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-select-round-rectangle
   */
  procedure = gimp_procedure_new (image_select_round_rectangle_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-select-round-rectangle");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-image-select-round-rectangle",
                                     "Create a rectangular selection with round corners over the specified image;",
                                     "This tool creates a rectangular selection with round corners over the specified image. The rectangular region can be either added to, subtracted from, or replace the contents of the previous selection mask.",
                                     "Martin Nordholts",
                                     "Martin Nordholts",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x",
                                                    "x",
                                                    "x coordinate of upper-left corner of rectangle",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y",
                                                    "y",
                                                    "y coordinate of upper-left corner of rectangle",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("width",
                                                    "width",
                                                    "The width of the rectangle",
                                                    0, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("height",
                                                    "height",
                                                    "The height of the rectangle",
                                                    0, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("corner-radius-x",
                                                    "corner radius x",
                                                    "The corner radius in X direction",
                                                    0, GIMP_MAX_IMAGE_SIZE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("corner-radius-y",
                                                    "corner radius y",
                                                    "The corner radius in Y direction",
                                                    0, GIMP_MAX_IMAGE_SIZE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("operation",
                                                  "operation",
                                                  "The selection operation",
                                                  GIMP_TYPE_CHANNEL_OPS,
                                                  GIMP_CHANNEL_OP_ADD,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-select-item
   */
  procedure = gimp_procedure_new (image_select_item_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-select-item");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-image-select-item",
                                     "Transforms the specified item into a selection",
                                     "This procedure renders the item's outline into the current selection of the image the item belongs to. What exactly the item's outline is depends on the item type: for layers, it's the layer's alpha channel, for vectors the vector's shape.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_item_id ("item",
                                                        "item",
                                                        "The item to render to the selection",
                                                        pdb->gimp, FALSE,
                                                        GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("operation",
                                                  "operation",
                                                  "The desired operation with current selection",
                                                  GIMP_TYPE_CHANNEL_OPS,
                                                  GIMP_CHANNEL_OP_ADD,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
