var CharacterClass = function(ownerStage, args)
{
	//args[imgAry0, ...]初期状態で描画したい画像のファイル名の配列（アニメーションさせる）を指定
	CharacterClass.base.apply(this, arguments);
	//キャラ独自の機能（たとえば攻撃や相手が当たってきたときのあたり判定など)
		
	this.interval = 15;
	this.imageState = -1;
	//-1:画像は無効
	// 0:左右歩行中または左右方向に向いて停止中（方向に関係なし。画像はすべて左向きで用意する。）
	// 1:攻撃アニメーション（一周分表示したら0に戻る）
	this.imageIndex = 0;
	this.imageList = [];
	this.lastImage = null;
	//キャラが向いている向き(0:Left,1:Right,[2:Up,3:Down])
	this.direction = 0;
	
	this.isItemCollector = true;
	this.lastFireTick = 0;
	this.fireTickInterval = 60;
	
	for(var k in args){
		var a = [];
		for(var f in args[k]){
			var img = document.createElement('img');
			img.src = "images/" + args[k][f];
			a.push(img);
		}
		this.imageList.push(a);
	}
	if(this.imageList.length > 0){
		this.imageState = 0;
	}
	
	//初期画像の設定
	if(this.imageList[0] && this.imageList[0].length > 0){
		this.lastImage = this.imageList[0][0];
	}
}.extend(MovableStageObjectClass, {
	className: "CharacterClass",
	draw: function(x, y){
		MovableStageObjectClass.prototype.draw.apply(this, arguments);
		if(this.lastImage){
			//コンテキスト変換行列を保存
			this.ownerStage.mainContext.save();
			//コンテキスト変換行列を設定
			switch(this.direction){
				case 1:
					//Right
					this.ownerStage.mainContext.transform(-1, 0, 0, 1, x + this.size.x, y);
					break;
				default:
					//Left, Up, Down, OtherState
					this.ownerStage.mainContext.transform(1, 0, 0, 1, x, y);
					break;
			}
			//描画
			this.ownerStage.mainContext.globalAlpha = this.opacity;
			this.ownerStage.mainContext.drawImage(this.lastImage, 0, 0, this.size.x, this.size.y);
			this.ownerStage.mainContext.globalAlpha = 1.0;
			//コンテキスト変換行列を復帰
			this.ownerStage.mainContext.restore();
		}
	},
	tick: function(){
		MovableStageObjectClass.prototype.tick.apply(this, []);
		
		if(this.ownerStage.manager.tickCount % this.interval == 0){
			//インターバル時刻になった
			if(this.imageState != -1){
				if(this.imageList[this.imageState]){
					if(this.imageList[this.imageState].length > 0){
						if(this.imageIndex >= this.imageList[this.imageState].length){
							this.imageIndex = 0;
							if(this.imageState == 1){
								this.imageState = 0;
							}
						}
						this.lastImage = this.imageList[this.imageState][this.imageIndex];
						if(!(this.imageState == 0 && this.movingSpeed.x == 0)){
							//imageState:0の時にspeed == 0のときは画像をアニメしない。それ以外の時はインデックスを進める。
							this.imageIndex ++;
						}
					} else{
						this.lastImage = null;
					}
				} else{
					this.lastImage = null;
				}
			} else{
				this.lastImage = null;
			}
		}
		if(this.movingSpeed.x < 0){
			this.direction = 0;
		} else if(this.movingSpeed.x > 0){
			this.direction = 1;
		}
	},
	fire: function()
	{
		if(this.lastFireTick < this.ownerStage.manager.tickCount - this.fireTickInterval){
			var f = new FireObjectClass(this.ownerStage, [["breadball1.png","breadball2.png","breadball3.png"]]);
			if(this.ownerStage.manager.breadItemWidget)
			{
				var score = this.ownerStage.manager.breadItemWidget.getLastSelectedBreadIndex();
				if(score != -1)
				{
					if(score > 50) score = 50;
					this.touchDamage *= (score / 50);
					f.fire(this);
					this.lastFireTick = this.ownerStage.manager.tickCount;
				}else
				{
					showAlert(this.ownerStage.manager, "武器が選択されていません");
				}
			}
		}
	}
	
});

