var EnemyCharacterClass = function(stage, args){
	EnemyCharacterClass.base.apply(this, arguments);
	
	this.movingVelocity = 150;
	
	//メインキャラクターを追跡する場合はtrue
	this.chasing = true;
	//メインキャラクターを感知する範囲（原点距離がこれ以内の場合に追跡をする。）
	this.chasingRange = 200;
	this.fightingRange = 32;
	this.chasingMode = 0;
	this.lastCollidedTick = 0;
	//他のキャラクターに与えるダメージの設定
	this.touchDamage = 10;
	this.damagePerTickBase = 60;
	this.damagePerTickCount = this.damagePerTickBase;
	this.damageLastTick = 0;
	this.damaging = false;
	//メインキャラクターから受けるダメージの設定
	this.hurt = 10;
	this.hurtPerTickBase = 60;
	this.hurtPerTickCount = this.hurtPerTickBase;
	this.hurtLastTick = 0;
	this.hurting = false;
	//
	this.max_HP = 20;
	this.HP = this.max_HP;
	this.isWeaponed = false;
	
	// 攻撃を受けた際などに一時的に無敵モードになるように
	// これがないと攻撃を受けたことが分かりにくくなる
	this.isDamageDefenseMode = false;
	this.damageDefenseModeTimeStamp = 0;
	this.damageDefenseModeLong = 500;
	
}.extend(OperatedCharacterClass, {
	className: "EnemyCharacterClass",
	tick : function()
	{
		if(this.isDamageDefenseMode)
		{
			if((+new Date()) > this.damageDefenseModeTimeStamp + this.damageDefenseModeLong)
			{
				this.isDamageDefenseMode = false;
			}
		}
		
		var main = this.ownerStage.userControlledCharacter;
		var distX = main.origin.x - this.origin.x - ((this.chasingMode == 0) ? this.fightingRange : -this.fightingRange);
		if(this.chasing && Math.abs(distX) <= this.chasingRange && Math.abs(this.origin.y - main.origin.y) <= this.chasingRange){
			//追跡処理
			if(distX > 0){
				this.goRight();
				if(this.chasingMode == 0){
					this.chasingMode = 1;
				}
			} else{
				this.goLeft();
				if(this.chasingMode == 1){
					this.chasingMode = 0;
				}
			}
			//攻撃処理
			if(this.isWeaponed){
				this.fire();
			}
		}
		//メインキャラへのダメージ
		if(this.damaging){
			if(this.damagePerTickCount == this.damagePerTickBase){
				main.damage(this.touchDamage);
				this.damagePerTickCount--;
			} else{
				this.damagePerTickCount--;
				if(this.damagePerTickCount <= 0){
					this.damagePerTickCount = this.damagePerTickBase;
				}
			}
		}
		//自分自身のダメージ
		if(this.hurting){
			if(!this.isDamageDefenseMode)
			{
				if(this.hurtPerTickCount == this.hurtPerTickBase){
					this.damage(this.hurt);
					this.hurtPerTickCount--;
				} else{
					this.hurtPerTickCount--;
					if(this.hurtPerTickCount <= 0){
						this.hurtPerTickCount = this.hurtPerTickBase;
					}
				}
			}
		}
		if(this.lastCollidedTick + 10 < this.ownerStage.manager.tickCount){
			if(this.hurting){
				//自分自身のダメージ無効
				this.hurting = false;
			}
			if(this.damaging){
				//キャラクターへのダメージ無効
				this.damaging = false;
			}
		}
		//落下後の死亡処理
		if(this.origin.y > 1000)
		{
			this.ownerStage.removeStageObject(this);
		}
		
		EnemyCharacterClass.base.prototype.tick.apply(this);
	},
	damage: function(d){
		//自分自身へのダメージ
		this.HP -= d;
		if(this.HP <= 0){
			this.ownerStage.removeStageObject(this);
		}
	},
	objectAttacked : function(obj, obj_x, obj_y, direction)
	{
		if(obj instanceof MainCharacterClass)
		{
			//メインキャラクターに衝突された
			//ダメージの開始・終了処理
			if(direction & CollideTop){
				if(!this.hurting){
					//自分自身のダメージ有効
					this.hurting = true;
					this.hurtPerTickCount = this.hurtPerTickBase;
				}
			} else{
				if(direction & (CollideLeft | CollideRight)){
					if(!this.damaging){
						//メインキャラクタへのダメージ有効
						this.damaging = true;
						this.damagePerTickCount = this.damagePerTickBase;
					}
				}
			}
			this.lastCollidedTick = this.ownerStage.manager.tickCount;
		}
	},
	draw: function(x, y){
		EnemyCharacterClass.base.prototype.draw.apply(this, arguments);
		this.ownerStage.mainContext.save();
		if(this.isDamageDefenseMode)
		{
			var d = ((+new Date()) - this.damageDefenseModeTimeStamp) / this.damageDefenseModeLong;
			this.ownerStage.mainContext.fillStyle = "rgba(255,0,0," + d + ")";
			this.ownerStage.mainContext.fillRectangle(x, y, this.size.x, this.size.y);
		}
		
		if(this.hurt > 0)
		{
			
			var backColor = "gray";
			var thickness = 4;
			var barWidth = this.max_HP;
			if(barWidth < 16) barWidth = 16;
			var barPerHP = this.HP / this.max_HP;
			var color = "green";
			
			if(barPerHP < 0.2)
			{
				color = "red";
			}else if(barPerHP < 0.4)
			{
				color = "yellow";
			}
			
			this.ownerStage.mainContext.fillStyle = backColor;
			this.ownerStage.mainContext.fillRect(x + (this.size.x - barWidth) / 2, y - thickness, barWidth, thickness);
			this.ownerStage.mainContext.fillStyle = color;
			this.ownerStage.mainContext.fillRect(x + (this.size.x - barWidth) / 2, y - thickness, barWidth * barPerHP, thickness);
		}
		this.ownerStage.mainContext.restore();
	}
});
