var FireObjectClass = function(stage, args){
	FireObjectClass.base.apply(this, arguments);
	
	this.fireVelocity = new Point2D(600, 100);
	this.isPhantom = true;
	this.size.x = 32;
	this.size.y = 32;
	this.movingSpeed.y = -this.fireVelocity.y;
	this.chasingRange = 0;
	this.isItemCollector = true;
	this.boundPower = 400;
	this.boundCount = 0;
	this.maxBoundCount = 3;
	this.maxLivingTick = 120;
	this.livingTick = 0;
}.extend(EnemyCharacterClass, {
	className: "FireObjectClass",
	fire: function(ownerObj, x, y){
		//発射位置の調整
		if(!x){
			x = 32;
		}
		if(ownerObj.direction == 0){
			//左
			this.origin.x = ownerObj.origin.x - x;
		} else{
			//右
			this.origin.x = ownerObj.origin.x + this.size.x + x;
		}
		if(!y){
			this.origin.y = ownerObj.origin.y;
		} else{
			this.origin.y = ownerObj.origin.y + y;
		}
		
		//発射
		var fvx = this.fireVelocity.x;
		if(ownerObj.direction == 0){
			//右
			fvx = -fvx;
			this.origin.x = ownerObj.origin.x - 32;
		}
		this.movingSpeed.x = fvx;
		this.movingSpeed.y = -this.fireVelocity.y
		
		// 初期位置で壁などに引っかかっていないか確認
		if(this.canMoveTo(this.origin.x, this.origin.y)){
			ownerObj.ownerStage.addStageObject(this, true);
		}
		this.livingTick = 0;
	},
	
	tick: function(){
		this.livingTick++;
		if(this.livingTick > this.maxLivingTick){
			this.ownerStage.removeStageObject(this);
		}
		FireObjectClass.base.prototype.tick.apply(this);
	},
	objectAttacked : function(obj, obj_x, obj_y, direction)
	{
		if(obj === this.ownerStage.userControlledCharacter)
		{
			//メインキャラクターに衝突された
			//ダメージの開始・終了処理
			if(direction & CollideTop){
				if(!this.hurting){
					//自分自身のダメージ有効
					this.hurting = true;
					this.hurtPerTickCount = this.hurtPerTickBase;
				}
			} else{
				if(direction & (CollideLeft | CollideRight)){
					if(!this.damaging){
						//メインキャラクタへのダメージ有効
						this.damaging = true;
						this.damagePerTickCount = this.damagePerTickBase;
					}
				}
			}
		}
		if(obj instanceof EnemyCharacterClass)
		{
			//ダメージの開始・終了処理
			obj.damage(this.touchDamage);
			this.ownerStage.removeStageObject(this);
		}
		if((obj instanceof BlockClass || obj instanceof SlopeBlockClass) && this.lastCollidedTick + 10 < this.ownerStage.manager.tickCount && !obj.isPhantom){
			this.movingSpeed.y -= this.boundPower;
			this.boundCount++;
			if(this.maxBoundCount <= this.boundCount){
				this.ownerStage.removeStageObject(this);
			}
		}
		
		this.lastCollidedTick = this.ownerStage.manager.tickCount;
	},

});
