//
//Canvas直接描画関連
//

//フォント設定方法
//context.font = "normal 20px sans-serif";

//色設定方法
//context.fillStyle = "rgba(200,255,200,0.5)";
//context.strokeStyle = "rgba(0, 0, 0, 0.5)";

function drawText(gcontext, text, x, y)
{
	//背景をfillStyle
	//前景をstrokeStyleで塗りつぶした文字列を描画する
	//塗りつぶし高さは20px固定
	//座標は文字列の左上の座標となる
	textsize = gcontext.measureText(text);
	gcontext.fillRect(x, y, textsize.width, 20);
	gcontext.save();
	gcontext.fillStyle = gcontext.strokeStyle;
	//fillText引数の座標は文字列の左下！
	gcontext.fillText(text, x, y + 20 - 1);
	gcontext.restore();
}

function drawArcDegree(gcontext, radius, startAngleDegree, endAngleDegree, x, y, anticlockwise)
{
	//半径radius, 中心座標(x,y)の円弧の、
	//startAngleDegreeからendAngleDegreeまでの範囲を、
	//(!anticlockwise)=時計回り
	//(anticlockwise) =反時計回り
	//に描画する。
	//角度は度を利用する。
	startAngleRadian = startAngleDegree * Math.PI / 180;
	endAngleRadian = endAngleDegree * Math.PI / 180;
	
	gcontext.beginPath();
	gcontext.arc(drawCoordinatesInInteger(x), drawCoordinatesInInteger(y), drawCoordinatesInInteger(radius), startAngleRadian, endAngleRadian, anticlockwise);
	gcontext.fill();
	gcontext.stroke();
	gcontext.closePath();
}

function fillRect(gContext, x, y, w, h)
{
	gContext.fillRect(drawCoordinatesInInteger(x), drawCoordinatesInInteger(y), drawCoordinatesInInteger(w), drawCoordinatesInInteger(h));
}

function strokeRect(gContext, x, y, w, h)
{
	gContext.strokeRect(drawCoordinatesInInteger(x), drawCoordinatesInInteger(y), drawCoordinatesInInteger(w), drawCoordinatesInInteger(h));
}

function drawCoordinatesInInteger(coordinateElement)
{
	//from http://www.html5rocks.com/ja/tutorials/canvas/performance/
	// With a bitwise or.
	return ((0.5 + coordinateElement) | 0);
}
