//操作キャラクター選択ステージ

stage = new GameStage();

stage.characterNameList = new Array();

stage.runStage = function(){
	GameStage.prototype.runStage.apply(this, []);
	
	var that = this;
	var characterSelectorClosed = function(retv){
		var tryAgain = true;
		if(retv){
			if(retv.length == 1){
				tryAgain = false;
			}
		}
		if(tryAgain){
			//もう一度選択させる
			var sw = new SelectWidgetClass(mainManager, [that.characterNameList, characterSelectorClosed, false, 0, true]);
			sw.enableCancel = false;
			mainManager.addWidget(sw);
		} else{
			//キャラクターを設定
			mainManager.userManager.characterBaseClass = retv[0].characterBaseClass;
			//データベースに設定を反映
			mainManager.networkManager.sendRequestSync("GET", URL_PCD_Auth + "?action=chcharacter&id=" + mainManager.userID + "&name=" + retv[0].characterBaseClass.prototype.className, null);
			//次のステージへ移動
			mainManager.loadStageFromNetwork("onieasy");
		}
	};
	
	var characterSelector = new SelectWidgetClass(mainManager, [this.characterNameList, characterSelectorClosed, false, 0, true]);
	characterSelector.enableCancel = false;
	mainManager.addWidget(characterSelector);
};

stage.addSelectWidgetItemFromCharacter = function(title, picName, baseClass, selected){
	var item = new SelectWidgetItemClass(false, picName, null, selected, "キャラクターを選択してください。\n◆" + title);
	item.size.x = 64;
	item.size.y = 128;
	item.characterBaseClass = baseClass;
	this.characterNameList.push(item);
}

//キャラクターリスト
stage.addSelectWidgetItemFromCharacter("森の狩人", "bowman1.png", MainCharacterClass_Hunter, true);
stage.addSelectWidgetItemFromCharacter("村の青年", "village2.png", MainCharacterClass_Man);
stage.addSelectWidgetItemFromCharacter("酔っ払い", "nakedman2.png", MainCharacterClass_NakedMan);
stage.addSelectWidgetItemFromCharacter("盗賊", "bandit2.png", MainCharacterClass_Thief);
stage.addSelectWidgetItemFromCharacter("魔女", "witch2.png", MainCharacterClass_Witch);
stage.addSelectWidgetItemFromCharacter("町の少女", "villagewoman3.png", MainCharacterClass_Woman);

stage;
