var stgObjects = {
	
	// BlockClass : 普通のブロック。 引数に画像名を指定
	
	b : {base:BlockClass,args:'1150.png'},
	f : {base:BlockClass,args:'1190.png'},
	t : {base:BlockClass,args:'1160.png'},
	x : {base:BlockClass,args:'1236.png'},
	j : {base:BlockClass,args:'1238.png'},
	y : {base:BlockClass,args:'1240.png'},
	h : {base:BlockClass,args:'1239.png'},
	ab: {base:BlockClass,args:'bridge.png'},
	
	
	
	i : {base:BlockClass,args:'1235.png'},
	n : {base:BlockClass,args:'leaves.png'},
	p : {base:BlockClass,args:'glass.png',prop:{collisionMarginLeft:31,}},
	ag : {base:BlockClass,args:'hosikusabelow.png'},
	r : {base:HiddenBlockClass,args:'hosikusa.png',adjust:[-10,0], prop:{collidingMask:CollideBottom, collidingExcludeMask:(CollideRight | CollideTop | CollideLeft | CollideBody)}},
	
	
	
	
	// SlopeBlockClass : 当たり判定が斜めのブロック。
	// 引数 : 画像名, 当たり判定領域左側の開始位置のブロック上辺からの高さ, 当たり判定領域右側の...
	//        たとえば、この例のように 0, 32 と指定すれば右下がりの坂になり、32, 0と指定すれば左下がり、 16, 16と指定すれば半分の高さの長方形になる
	// enableBlockMode : 当たり判定領域をデバッグ表示する。
	
	c : {base:SlopeBlockClass,args:['1152.png',32,0],prop:{enableDebugMode:true}},
	d : {base:SlopeBlockClass,args:['1213.png',16,16],prop:{enableDebugMode:true}},
	a : {base:SlopeBlockClass,args:['kusa.png',64,64],prop:{enableDebugMode:true}},
	g : {base:SlopeBlockClass,args:['1151.png',0,32],prop:{enableDebugMode:true}},
	e : {base:SlopeBlockClass,args:['1214.png',128,128],prop:{enableDebugMode:true}},
	l : {base:SlopeBlockClass,args:['leavesedge1.png',16,0],prop:{enableDebugMode:true}},
	m : {base:SlopeBlockClass,args:['leavesedge2.png',0,16],prop:{enableDebugMode:true}},
	o : {base:SlopeBlockClass,args:['stop.png',35,35],prop:{enableDebugMode:true}},
	q : {base:SlopeBlockClass,args:['hosikusa.png',9,9],prop:{enableDebugMode:true}},
	s : {base:SlopeBlockClass,args:['leaves.png',1500,1500],prop:{enableDebugMode:true}},
	u : {base:SlopeBlockClass,args:['1162.png',33,-3],prop:{enableDebugMode:true}},
	w : {base:SlopeBlockClass,args:['1161.png',-3,33],prop:{enableDebugMode:true}},
	z : {base:SlopeBlockClass,args:['1164.png',33,-3],prop:{enableDebugMode:true}},
	aa : {base:SlopeBlockClass,args:['fence.png',600,600],prop:{enableDebugMode:true}},
	ad : {base:SlopeBlockClass,args:['fence.png',16,16],prop:{enableDebugMode:true}},
	
	af : {base:SlopeBlockClass,args:['toge.png',0,0],prop:{enableDebugMode:true}},
	
	// FreeItemClass : キャラが取得するとコールバックが実行されるアイテム
	// callback : 誰かに取得されたときに発生するコールバック。アタックした人、そのアタック直後のx, y座標が引数にセットされる。
	// times : 取得できる回数で、-1で無限。
	k : {base:RandomIngredientItemClass,args:[null,"glass.png",],prop:{debugMode:true}},
	K : {base:RandomIngredientItemClass,args:[],prop:{debugMode:true}},	
	ac : {base:FreeItemClass,args:["bridgedameged.png",callBack],prop:{times:1,DebugMode:true,}},
	ah : {base:FreeItemClass,args:["stop.png",callBack1],prop:{times:1,DebugMode:true,}},
	ai : {base:BakingOvenObjectClass,args:[]},
	
	
	
	// 何もブロックを置かない位置のためにかならずこのようなエントリーを記述
	_ : null
};

function callBack0(obj,x,y)
{
		if(obj instanceof MainCharacterClass){mainManager.addWidget(new MessageWidgetClass(mainManager, ["アイテムゲッツ\n"]));
		
	}
};


function callBack(obj,x,y)
{
		if(obj instanceof MainCharacterClass){mainManager.addWidget(new MessageWidgetClass(mainManager, ["ガタッ\n"]));
		
	}
};


function callBack1(obj,x,y)
{
		if(obj instanceof MainCharacterClass){mainManager.addWidget(new MessageWidgetClass(mainManager, ["老朽化のため橋桁の崩落に注意\n"]));
		
	}
};



var stgInfo = {
	width: 6400,				//横サイズ
	height: 480,				//縦サイズ
	background: "back2.png",		//背景画像。横幅は640pxである必要はない。
	BGM:   "boss.mp3"
	//"Metal_Gear_Solid_OST_Encounter.mp3",
	//"Mount_Blade_With_Fire_and_Sword_OST_-_Happy_Song.mp3",
};

with(stgObjects){
	var tbl = [
	[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,p],
	[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,p],
	[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,p],
	[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,p],
	[_,_,_,_,_,_,K,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,r,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,i,i],
	[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,l,s,m,_,_,_,_,_,_, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,p],
	[_,_,_,_,_,_,_,_,l,n,m,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,l,s,m,_,_,_,l,k,m,_,_,_,_,_,_, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,p],
	[_,_,_,_,_,_,_,l,n,s,s,m,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,ah,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,l,s,m,_,_,l,s,s,s,m,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,i,_,_,_,_,_,_,i,_, , , , ,p],
	[_,_,_,_,_,_,_,l,n,k,s,m,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,u,t,t,w,aa,aa,aa,aa,aa,aa,aa,aa,aa,aa,aa,aa,aa,aa,_,_,_,_,_,_,_,_,_,l,s,s,s,m,_,l,s,s,s,m,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,ag, , , , , , , , , , , , , , , , , , , , , , , ,p],
	[_,_,_,_,_,_,_,l,n,n,n,m,_,_,_,_,_,o,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,ai,_,_,_,_,_,_,_,_,_,_,_,_,_,_,u,t,t,t,t,t,ab,ab,ab,ac,ac,ab,ac,ac,ab,ac,ac,ac,ab,ac,t,t,t,t,t,w,_,_,_,l,s,s,s,m,_,_,l,n,m,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,i,K,i,_,_,_,_,_,ag,ag, , , , , , , , , , , , , , , , , , , , , , , ,p],
	[_,_,i,K,i,_,_,_,_,e,_,_,_,_,_,a,c,b,g,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,r,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,q,_,_,_,_,_,_,_,_,z,t,t,t,t,t,t,t,j,_,_,_,_,_,_,_,_,_,_,_,_,k,t,t,t,t,t,t,j,_,_,_,l,n,m,_,_,_,_,e,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,ag,ag,ag,_,_,_,_,_,_, ,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,i,i],
	[_,_,_,_,_,_,_,_,_,e,_,_,a,a,c,b,b,b,b,g,_,_,_,_,_,_,_,_,_,ag,ag,ag,ag,_,_,_,_,_,_,_,_,_,_,_,_,_,_,k,q,q,_,_,_,_,_,q,ag,a,a,a,a,a,a,_,u,t,t,t,t,t,t,t,t,j,_,_,_,_,_,_,_,_,_,_,_,_,y,t,t,t,t,t,t,j,_,_,_,_,e,_,_,_,_,_,e,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,ag,ag,ag,ag,_,_,_,_,_, , , , , , , , , , , , , , , , , , ,p],
	[_,_,_,_,_,_,a,a,a,e,a,c,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,g,_,q,q,_,_,_,_,_,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,x,t,t,t,t,t,t,t,t,t,j,_,_,_,_,_,_,_,_,_,_,_,_,h,t,t,t,t,t,t,j,a,a,a,a,e,a,a,a,d,a,e,a,a,a,ad,ad,ad,ad,ad,ad,ad,_,_,_,_,_,_,_,_,ad,_,_,_,_, , , ,_,_, ,_,af,_, , , , , , , , ,af,af,af, , ,ad,a,a,a,a,a,a,a,a,a,a,a,a,q,_,a,a,a,a,a,a,ag,ag,ag,ag,ag, , , , , , , , , , , , , , , , , , , , , , , ,p],
	[a,d,a,a,a,c,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,x,t,t,t,t,t,t,t,t,t,j,_,_,_,_,_,_,_,_,_,_,_,_,h,t,t,t,t,t,t,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,_,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b],
	[f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,j,_,_,_,_,_,_,_,_,_,_,_,_,h,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,_,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f]
	];
}
//約束事
var stage = new PCDSLStageClass(stgInfo, tbl);


stage.runStage = function(){
	PCDSLStageClass.prototype.runStage.apply(this, []);
	
	var e1 = new EnemyCharacterClass_PanTank(stage);
	e1.origin.x = 2800;
	e1.origin.y = 0;
	
	var e2 = new EnemyCharacterClass_Rat(stage);
	e2.origin.x = 500;
	e2.origin.y = 200;
	
	var e3 = new EnemyCharacterClass_Farmer(stage);
	e3.origin.x = 6200;
	e3.origin.y = 300;
	
	var e4 = new EnemyCharacterClass_Bear(stage);
	e4.origin.x = 5000;
	e4.origin.y = 300;
	
	var e5 = new EnemyCharacterClass_Rat(stage);
	e5.origin.x = 1440;
	e5.origin.y = 220;
	e5.chasingRange = 270;
	e5.collisionMargin.top = 15;
	e5.movingVelocity = 200;
	
	var e7 = new EnemyCharacterClass_Rat(stage);
	e7.origin.x = 5596;
	e7.origin.y = 0;
	e7.chasingRange = 270;
	e7.movingVelocity = 70;
	
	var e8 = new EnemyCharacterClass_Rat(stage);
	e8.origin.x = 5532;
	e8.origin.y = 0;
	e8.chasingRange = 270;
	e8.movingVelocity = 70;
	
	var e9 = new EnemyCharacterClass_Rat(stage);
	e9.origin.x =5564;
	e9.origin.y = 0;
	e9.chasingRange = 270;
	e9.movingVelocity = 70;
	
	
	
	var e11 = new EnemyCharacterClass_Spine(stage);
	e11.origin.x =3968;
	e11.origin.y =383;
	e11.collisionMarginTop = 28;
	
	var e12 = new EnemyCharacterClass_Spine(stage);
	e12.origin.x =4000;
	e12.origin.y =383;
	e12.collisionMarginTop = 28;
	
	var e13 = new EnemyCharacterClass_Spine(stage);
	e13.origin.x =4032;
	e13.origin.y =383;
	e13.collisionMarginTop = 28;
	
	var e14 = new EnemyCharacterClass_Spine(stage);
	e14.origin.x =4064;
	e14.origin.y =383;
	e14.collisionMarginTop = 28;
	
	var e15 = new EnemyCharacterClass_Spine(stage);
	e15.origin.x =4096;
	e15.origin.y =383;
	e15.collisionMarginTop = 28;
	
	var e16 = new EnemyCharacterClass_Spine(stage);
	e16.origin.x =4128;
	e16.origin.y =383;
	e16.collisionMarginTop = 28;
	
	var e17 = new EnemyCharacterClass_Spine(stage);
	e17.origin.x =4160;
	e17.origin.y =383;
	e17.collisionMarginTop = 28;
	
	var e18 = new EnemyCharacterClass_Spine(stage);
	e18.origin.x =4192;
	e18.origin.y =383;
	e18.collisionMarginTop = 28;
	
	var e19 = new EnemyCharacterClass_Spine(stage);
	e19.origin.x =4226;
	e19.origin.y =383;
	e19.collisionMarginTop = 28;
	
	var e20 = new EnemyCharacterClass_Spine(stage);
	e20.origin.x =4258;
	e20.origin.y =383;
	e20.collisionMarginTop = 28;
	
	var e21 = new EnemyCharacterClass_Spine(stage);
	e21.origin.x =4290;
	e21.origin.y =383;
	e21.collisionMarginTop = 28;
	
	
	
	var e23 = new EnemyCharacterClass_Spine(stage);
	e23.origin.x =4354;
	e23.origin.y =383;
	e23.collisionMarginTop = 28;
	
	var e24 = new EnemyCharacterClass_Spine(stage);
	e24.origin.x =4386;
	e24.origin.y =383;
	e24.collisionMarginTop = 28;
	
	var e25 = new EnemyCharacterClass_Spine(stage);
	e25.origin.x =4418;
	e25.origin.y =383;
	e25.collisionMarginTop = 28;
	
	var e26 = new EnemyCharacterClass_Spine(stage);
	e26.origin.x =4450;
	e26.origin.y =383;
	e26.collisionMarginTop = 28;
	
	var e27 = new EnemyCharacterClass_Spine(stage);
	e27.origin.x =4482;
	e27.origin.y =383;
	e27.collisionMarginTop = 28;
	
	var e28 = new EnemyCharacterClass_Spine(stage);
	e28.origin.x =4514;
	e28.origin.y =383;
	e28.collisionMarginTop = 28;
	
	var e29 = new EnemyCharacterClass_Spine(stage);
	e29.origin.x =4546;
	e29.origin.y =383;
	e29.collisionMarginTop = 28;
	
	var e30 = new EnemyCharacterClass_Spine(stage);
	e30.origin.x =4578;
	e30.origin.y =383;
	e30.collisionMarginTop = 28;
	
	var e31 = new EnemyCharacterClass_Spine(stage);
	e31.origin.x =4736;
	e31.origin.y =383;
	e31.collisionMarginTop= 28;
	
	var e32 = new EnemyCharacterClass_Spine(stage);
	e32.origin.x =4768;
	e32.origin.y =383;
	e32.collisionMarginTop = 28;
	
	var e33 = new EnemyCharacterClass_Spine(stage);
	e33.origin.x =4610;
	e33.origin.y =383;
	e33.collisionMarginTop = 28;
	
	
	
	
	
	
	
	
	
	
	
	var c1 = new EnemyCharacterClass(stage, [["cowm1.png","cowm2.png","cowm3.png","cowm4.png","cowm3.png","cowm2.png",]]);
	c1.size.x = 100;
	c1.size.y=  50;
	c1.origin.x =730;
	c1.origin.y =0;
	c1.chasingRange = 200;
	c1.ownerUID = stage.manager.userID;
	c1.movingVelocity = 80;
	c1.collisionMargin.top = 14;
	c1.collisionMargin.right = 16;
	c1.collisionMargin.left = 16;
	c1.touchDamage = 0;
	
	//メインキャラクターから受けるダメージの設定
	c1.hurt = 0;
	
	stage.addStageObject(c1);
	
	
	var c2 = new EnemyCharacterClass(stage, [["cowm1.png","cowm2.png","cowm3.png","cowm4.png","cowm3.png","cowm2.png",]]);
	c2.size.x = 105;
	c2.size.y=  55;
	c2.origin.x =820;
	c2.origin.y =0;
	c2.chasingRange = 200;
	c2.ownerUID = stage.manager.userID;
	c2.movingVelocity = 150;
	c2.collisionMargin.top = 14;
	c2.collisionMargin.right = 16;
	c2.collisionMargin.left = 16;
	c2.touchDamage = 0;
	
	//メインキャラクターから受けるダメージの設定
	c2.hurt = 0;
	
	stage.addStageObject(c2);
	
	
	
	
	
	
	var barn = new BlockClass(stage, ["barn.png",]);
	
	barn.size.x = 200;
	barn.size.y = 150;
	barn.origin.x = 1332;
	barn.origin.y =236;
	barn.collisionMargin.top = 44;
	barn.collisionMargin.right = 30;
	stage.addStageObject(barn);
	
	var barn2 = new SlopeBlockClass(stage, ["barn.png", 49, 49]);
	
	barn2.size.x = 170;
	barn2.size.y = 150;
	barn2.origin.x = 3700;
	barn2.origin.y =266;
	stage.addStageObject(barn2);
	
	var windmill = new SlopeBlockClass(stage, ["windmill.png", 5, 5]);
	windmill.size.x = 50;
	windmill.size.y = 150;
	windmill.origin.x = 1600;
	windmill.origin.y =236;
	stage.addStageObject(windmill);
	
	
	
	var fence0 = new SlopeBlockClass(stage, ["fence.png", 16, 16]);
	fence0.size.x = 32;
	fence0.size.y = 32;
	fence0.origin.x = 672;
	fence0.origin.y = 352;
	stage.addStageObject(fence0);
	
	var fence13 = new SlopeBlockClass(stage, ["fence.png", 32, 32]);
	fence13.size.x = 32;
	fence13.size.y = 32;
	fence13.origin.x = 704;
	fence13.origin.y = 352;
	stage.addStageObject(fence13);
	
	var fence = new SlopeBlockClass(stage, ["fence.png", 32, 32]);
	fence.size.x = 32;
	fence.size.y = 32;
	fence.origin.x = 736;
	fence.origin.y = 352;
	stage.addStageObject(fence);
	
	var fence2 = new SlopeBlockClass(stage, ["fence.png", 32, 32]);
	fence2.size.x = 32;
	fence2.size.y = 32;
	fence2.origin.x = 768;
	fence2.origin.y = 352;
	stage.addStageObject(fence2);
	
	var fence3 = new SlopeBlockClass(stage, ["fence.png", 32, 32]);
	fence3.size.x = 32;
	fence3.size.y = 32;
	fence3.origin.x = 800;
	fence3.origin.y = 352;
	stage.addStageObject(fence3);
	
	var fence4 = new SlopeBlockClass(stage, ["fence.png", 32, 32]);
	fence4.size.x = 32;
	fence4.size.y = 32;
	fence4.origin.x = 832;
	fence4.origin.y = 352;
	stage.addStageObject(fence4);
	
	var fence5 = new SlopeBlockClass(stage, ["fence.png", 32, 32]);
	fence5.size.x = 32;
	fence5.size.y = 32;
	fence5.origin.x = 864;
	fence5.origin.y = 352;
	stage.addStageObject(fence5);
	
	var fence6 = new SlopeBlockClass(stage, ["fence.png", 32, 32]);
	fence6.size.x = 32;
	fence6.size.y = 32;
	fence6.origin.x = 896;
	fence6.origin.y = 352;
	stage.addStageObject(fence6);
	
	var fence7 = new SlopeBlockClass(stage, ["fence.png", 32, 32]);
	fence7.size.x = 32;
	fence7.size.y = 32;
	fence7.origin.x = 928;
	fence7.origin.y = 352;
	stage.addStageObject(fence7);
	
	var fence8 = new SlopeBlockClass(stage, ["fence.png", 32, 32]);
	fence8.size.x = 32;
	fence8.size.y = 32;
	fence8.origin.x = 960;
	fence8.origin.y = 352;
	stage.addStageObject(fence8);
	
	var fence9 = new SlopeBlockClass(stage, ["fence.png", 32, 32]);
	fence9.size.x = 32;
	fence9.size.y = 32;
	fence9.origin.x = 992;
	fence9.origin.y = 352;
	stage.addStageObject(fence9);
	
	var fence10 = new SlopeBlockClass(stage, ["fence.png", 16, 16]);
	fence10.size.x = 32;
	fence10.size.y = 32;
	fence10.origin.x = 1024;
	fence10.origin.y = 352;
	stage.addStageObject(fence10);
	
	var fence11 = new SlopeBlockClass(stage, ["fence.png", 16, 16]);
	fence11.size.x = 32;
	fence11.size.y = 32;
	fence11.origin.x = 3712;
	fence11.origin.y = 384;
	stage.addStageObject(fence11);
	
	var fence12 = new SlopeBlockClass(stage, ["fence.png", 16, 16]);
	fence12.size.x = 32;
	fence12.size.y = 32;
	fence12.origin.x = 3680;
	fence12.origin.y = 384;
	stage.addStageObject(fence12);
	
	var cow4 = new BlockClass(stage, ["cow.png",]);
	cow4.size.x = 100;
	cow4.size.y = 46;
	cow4.origin.x = 4010;
	cow4.origin.y = 365;
	cow4.collisionMargin.top = 14;
	cow4.collisionMargin.right = 16;
	cow4.collisionMargin.left = 16;
	
	stage.addStageObject(cow4);
	
	var cow5 = new BlockClass(stage, ["cow2.png",]);
	cow5.size.x = 100;
	cow5.size.y = 46;
	cow5.origin.x = 4180;
	cow5.origin.y = 365;
	cow5.collisionMargin.top = 14;
	cow5.collisionMargin.right = 16;
	cow5.collisionMargin.left = 16;
	stage.addStageObject(cow5);
	
	var cow6 = new BlockClass(stage, ["cow.png",]);
	cow6.size.x = 100;
	cow6.size.y = 46;
	cow6.origin.x = 4420;
	cow6.origin.y = 365;
	cow6.collisionMargin.top = 100;
	cow6.collisionMargin.right = 16;
	cow6.collisionMargin.left = 16;
	stage.addStageObject(cow6);
	
	var cow7 = new BlockClass(stage, ["cow2.png",]);
	cow7.size.x = 100;
	cow7.size.y = 46;
	cow7.origin.x = 4480;
	cow7.origin.y = 365;
	cow7.collisionMargin.top = 14;
	cow7.collisionMargin.right = 16;
	cow7.collisionMargin.left = 16;
	stage.addStageObject(cow7);
	
	var leaf1 = new BlockClass(stage, ["leaves.png",]);
	leaf1.size.x = 32;
	leaf1.size.y = 32;
	leaf1.origin.x = 288;
	leaf1.origin.y = 256;
	leaf1.collisionMargin.top = 600;
	
	stage.addStageObject(leaf1);
	
	var leaf2 = new BlockClass(stage, ["leaves.png",]);
	leaf2.size.x = 32;
	leaf2.size.y = 32;
	leaf2.origin.x = 3328;
	leaf2.origin.y = 192;
	leaf2.collisionMargin.top = 600;
	stage.addStageObject(leaf2);
	
	var warpLeft = new WarpItemClass(stage, ["panya", 60, 0, 32, 480, false]);
	warpLeft.origin.x = -32;
	warpLeft.origin.y = 0;
	stage.addStageObject(warpLeft);

	var warpRight = new WarpItemClass(stage, ["panya", 60, 0, 32, 100, false]);
	warpRight.origin.x = 6336;
	warpRight.origin.y = 0;
	stage.addStageObject(warpRight);

},


stage;