/* ------------------------------------------------------------------------ */
/* Hyper Operating System V4 Advance                                        */
/*                                                                          */
/*                                  Copyright (C) 2011 by Project HOS       */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


				.text


/************************************************
  実行コンテキストエントリーアドレス
 ************************************************/
				.align	2
ctx_entry:	 	
				addik	r5, r22, 0				/* 実行時パラメータ1を設定 */
				brad	r21						/* 実行開始アドレスに分岐 */
				addik	r6, r23, 0				/* 実行時パラメータ2を設定(遅延スロット) */


/************************************************
  実行コンテキストの作成
  _kernel_cre_ctx(
		_KERNEL_T_CTXCB *pk_ctxcb,	作成するコンテキスト [r5]
		VP              isp,		初期スタックポインタ [r6]
		FP              entry,		実行アドレス         [r7]
		VP_INT          par1,		実行時パラメータ1    [r8]
		VP_INT          par2)		実行時パラメータ2    [r9]
 ************************************************/
				.align	2
				.global	_kernel_cre_ctx
_kernel_cre_ctx:
				addik 	r6, r6, -(56+28)		/* スタックに領域を確保 */
				addik	r3, r0, ctx_entry - 8
				swi		r7, r6, 12				/* 実行アドレスを r21 の領域に設定 */
				swi		r8, r6, 16				/* 実行時パラメータ1を r22 の領域に設定 */
				swi		r9, r6, 20				/* 実行時パラメータ2を r23 の領域に設定 */
				swi		r3, r6, 0				/* 実行エントリポイントを r15 の領域に設定 */
				rtsd	r15, 8
				swi		r6, r5, 0				/* スタックポインタを保存(遅延スロット) */


/* end of file */
