package iax.client.protocol.call.command.send;

import iax.client.protocol.call.Call;
import iax.client.protocol.frame.InfoElement;
import iax.client.protocol.frame.ProtocolControlFrame;
import iax.client.protocol.util.Converter;
import iax.client.protocol.util.FrameUtil;

//import org.bouncycastle.crypto.digests.MD5Digest;

/**
 * Sends an authorization request
 */
public class AuthRep {

    public static void execute(Call call, ProtocolControlFrame authReqFrame) {
        try {
            String userName = authReqFrame.getUserName();
            int auth = authReqFrame.getAuthMethods();
            String challenge = authReqFrame.getChallenge();
            if (userName.equals(call.getPeer().getUserName())) {
                String password = call.getPeer().getPassword();
                ProtocolControlFrame authRepFrame = new ProtocolControlFrame(call.getSrcCallNo(), false, call.getDestCallNo(),
                        call.getTimestamp(), call.getOseqno(), call.getIseqno(), false, ProtocolControlFrame.AUTHREP_SC);
                authRepFrame.setUserName(userName);
                switch (auth) {
                case InfoElement.MD5_RSA_V:
                case InfoElement.MD5_V:
                    password = Converter.byteArrayToHexString(FrameUtil.md5(challenge.getBytes(), password.getBytes()));
                    authRepFrame.setMD5Result(password);
                    break;
                case InfoElement.RSA_V:
                    //TODO: RSA password.
                    // pcf.setRSAResult()
                    break;
                case InfoElement.PLAIN_V:
                    authRepFrame.setMD5Result(password);
                    break;
                default:
                    break;
                }
                call.handleSendFrame(authRepFrame);
            } //TODO else (when isn't our username)
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
