package iax.client.protocol.user.command;

import iax.client.protocol.call.Call;
import iax.client.protocol.frame.ControlFrame;
import iax.client.protocol.peer.Peer;

/**
 * Implements the user command that accepts a call.
 */
public class AnswerCall {
    
    public static void execute(Peer peer){
        try {
            Call call = peer.getCall();
            
            ControlFrame answerFrame = 
                new ControlFrame(call.getSrcCallNo(), false, call.getDestCallNo(), call.getTimestamp(), call.getOseqno(),
                        call.getIseqno(), false, ControlFrame.ANSWER, new byte[0]);

            call.startRecorder();
            call.handleSendFrame(answerFrame);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
}