package iax.client.protocol.user.command;

import iax.client.protocol.call.Call;
import iax.client.protocol.frame.ProtocolControlFrame;
import iax.client.protocol.peer.Peer;

/**
 * Implements the user command that transfers a call.
 */
public class TransferCall {

    public static void execute(Peer peer, String dstNumber) {
        try {
            Call call = peer.getCall();

            ProtocolControlFrame transferCallFrame = 
                new ProtocolControlFrame(call.getSrcCallNo(), false, call.getDestCallNo(), call.getTimestamp(), call.getOseqno(),
                        call.getIseqno(), false, ProtocolControlFrame.TRANSFER_SC);
            transferCallFrame.setCalledNumber(dstNumber);
            call.handleSendFrame(transferCallFrame);
            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}